/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnexpectedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.YmlObject;
import com.github.onyxiansoul.damagepotioneffects.utils.ConfigurationUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SectionBasedYmlObject
extends YmlObject {
    private final Map<String, Object> fullRawObjectValues;
    @Nullable
    private final ConfigurationSection localReferenceSection;
    @Nullable
    private final ConfigurationSection remoteReferenceSection;
    @NotNull
    private final String compoundObjectSectionName;
    @NotNull
    private final Set<ConfigurationSection> forbiddenSections;
    @NotNull
    private final String allowedReferenceSections;

    public SectionBasedYmlObject(@NotNull ConfigurationSection compoundObjectSection, @Nullable ConfigurationSection localReferenceSection, @Nullable ConfigurationSection remoteReferenceSection, @Nullable Set<ConfigurationSection> forbiddenSections) throws UnexpectedConfigurationException {
        if (forbiddenSections == null) {
            forbiddenSections = new HashSet<ConfigurationSection>();
        }
        forbiddenSections.add(compoundObjectSection);
        this.forbiddenSections = forbiddenSections;
        this.compoundObjectSectionName = ConfigurationUtil.getSectionName(compoundObjectSection);
        this.localReferenceSection = localReferenceSection;
        this.remoteReferenceSection = remoteReferenceSection;
        this.allowedReferenceSections = this.getReferenceSectionsName();
        this.fullRawObjectValues = this.createFullRawValues(compoundObjectSection);
    }

    private String getReferenceSectionsName() {
        StringBuilder referenceSectionsBuilder = new StringBuilder();
        referenceSectionsBuilder.append("{");
        if (this.localReferenceSection != null) {
            referenceSectionsBuilder.append(ConfigurationUtil.getSectionName(this.localReferenceSection));
        }
        if (this.remoteReferenceSection != null) {
            referenceSectionsBuilder.append(ConfigurationUtil.getSectionName(this.remoteReferenceSection));
        }
        referenceSectionsBuilder.append("}");
        return referenceSectionsBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> createFullRawValues(ConfigurationSection compoundObjectSection) throws UnexpectedConfigurationException {
        if (!compoundObjectSection.isString("default from")) {
            return compoundObjectSection.getValues(false);
        }
        ConfigurationSection referencedSection = null;
        String reference = compoundObjectSection.getString("default from");
        if (ConfigurationUtil.isLocalReferenceAttempt(reference)) {
            reference = reference.substring(7, reference.length() - 1);
            if (this.localReferenceSection == null || !this.localReferenceSection.isConfigurationSection(reference)) throw new UnexpectedConfigurationException(compoundObjectSection, "Found reference:" + reference + " But thats not a local section");
            referencedSection = this.localReferenceSection.getConfigurationSection(reference);
        } else if (this.remoteReferenceSection != null && this.remoteReferenceSection.isConfigurationSection(reference)) {
            referencedSection = this.remoteReferenceSection.getConfigurationSection(reference);
        }
        if (referencedSection == null) throw new UnexpectedConfigurationException(compoundObjectSection, "Found reference: " + reference + " But that doesn't exist inside" + this.allowedReferenceSections);
        SectionBasedYmlObject referencedObject = new SectionBasedYmlObject(referencedSection, this.localReferenceSection, this.remoteReferenceSection, this.forbiddenSections);
        return this.mergeValues(compoundObjectSection.getValues(false), referencedObject.getFullRawObjectValues());
    }

    private Map<String, Object> mergeValues(Map<String, Object> baseMap, Map<String, Object> mapToComplete) {
        for (String entry : mapToComplete.keySet()) {
            if (baseMap.containsKey(entry)) continue;
            baseMap.put(entry, mapToComplete.get(entry));
        }
        return baseMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Object getField(@NotNull String fieldKey) throws NullPointerException, IllegalArgumentException {
        if (!this.fullRawObjectValues.containsKey(fieldKey)) throw new NullPointerException("Field: " + fieldKey + " Doesn't exist inside: " + this.compoundObjectSectionName);
        Object fieldValueAsObject = this.fullRawObjectValues.get(fieldKey);
        if (!(fieldValueAsObject instanceof String) || !ConfigurationUtil.isCopyAttempt((String)fieldValueAsObject)) return this.fullRawObjectValues.get(fieldKey);
        ConfigurationSection referencedSection = null;
        String reference = (String)fieldValueAsObject;
        if (ConfigurationUtil.isLocalReferenceAttempt(reference = reference.substring(6, reference.length() - 1))) {
            if (this.localReferenceSection == null) throw new IllegalArgumentException("Found reference " + reference + " Trying to reference inside the local section, but for this section, this is not allowed");
            if (!this.localReferenceSection.isConfigurationSection(reference = reference.substring(7, reference.length() - 1))) {
                throw new IllegalArgumentException("Found reference " + reference + " But it doesn't exist Inside: " + ConfigurationUtil.getSectionName(this.localReferenceSection));
            }
        } else {
            if (this.remoteReferenceSection == null) throw new IllegalArgumentException("Found reference " + reference + " Trying to reference a remote section, but for this section, this is not allowed");
            if (!this.remoteReferenceSection.isConfigurationSection(reference)) throw new IllegalArgumentException("Found reference " + reference + " But there is no remote object of name: " + reference + "Inside: " + ConfigurationUtil.getSectionName(this.remoteReferenceSection));
            referencedSection = this.remoteReferenceSection.getConfigurationSection(reference);
            throw new IllegalArgumentException("Found reference " + reference + " But there is no remote object of name: " + reference + "Inside: " + ConfigurationUtil.getSectionName(this.remoteReferenceSection));
        }
        referencedSection = this.localReferenceSection.getConfigurationSection(reference);
        try {
            SectionBasedYmlObject referencedObject = new SectionBasedYmlObject(referencedSection, this.localReferenceSection, this.remoteReferenceSection, this.forbiddenSections);
            return referencedObject.getField(fieldKey);
        }
        catch (UnexpectedConfigurationException e) {
            throw new IllegalArgumentException("Found reference" + reference + "On the field: " + fieldKey + " But the refered object doesnt exist inside: " + this.allowedReferenceSections);
        }
    }

    public Map<String, Object> getFullRawObjectValues() {
        return this.fullRawObjectValues;
    }

    public String toString() {
        return "SectionBasedYmlObject{fullRawObjectValues=" + this.fullRawObjectValues + ", localReferenceSection=" + this.localReferenceSection + ", remoteReferenceSection=" + this.remoteReferenceSection + ", compoundObjectSectionName=" + this.compoundObjectSectionName + ", forbiddenSections=" + this.forbiddenSections + ", allowedReferenceSections=" + this.allowedReferenceSections + "}";
    }
}

