/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnexpectedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.SectionBasedYmlObject;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.YmlObject;
import com.github.onyxiansoul.damagepotioneffects.utils.CollectionUtils;
import com.github.onyxiansoul.damagepotioneffects.utils.ConfigurationUtil;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapBasedYmlObject
extends YmlObject {
    @NotNull
    private final Map<String, Object> fullRawObjectValues;
    @NotNull
    private final String listName;
    @NotNull
    private final String compoundObjectName;
    @Nullable
    private final ConfigurationSection remoteReferencesSection;

    public MapBasedYmlObject(@NotNull Map<String, Object> objectEntry, @NotNull String referenceListName, @Nullable ConfigurationSection cousinSection) throws UnexpectedConfigurationException {
        this.compoundObjectName = objectEntry.keySet().iterator().next();
        this.listName = referenceListName;
        this.remoteReferencesSection = cousinSection;
        this.fullRawObjectValues = this.createFullRawValues(objectEntry);
    }

    @NotNull
    private Map<String, Object> createFullRawValues(Map<String, Object> objectEntry) throws UnexpectedConfigurationException {
        HashMap<String, Object> objectFieldValues = CollectionUtils.safelyCastMap((Map)Map.class.cast(objectEntry.values().iterator().next()), String.class, Object.class);
        if (!objectFieldValues.containsKey("default from") || !(objectFieldValues.get("default from") instanceof String)) {
            return objectFieldValues;
        }
        String reference = (String)String.class.cast(objectFieldValues.get("default from"));
        if (ConfigurationUtil.isLocalReferenceAttempt(reference)) {
            String exceptionText = "The list entry:" + this.compoundObjectName + "Is trying to default from another list entry, but that is impossible";
            if (this.remoteReferencesSection != null) {
                exceptionText = exceptionText + "Please consider moving the object to " + ConfigurationUtil.getSectionName(this.remoteReferencesSection) + " In order to be able to refer it";
            }
            throw new UnexpectedConfigurationException(this.listName, exceptionText);
        }
        if (this.remoteReferencesSection != null && this.remoteReferencesSection.isConfigurationSection(reference)) {
            ConfigurationSection referencedSection = this.remoteReferencesSection.getConfigurationSection(reference);
            SectionBasedYmlObject referencedObject = new SectionBasedYmlObject(referencedSection, null, this.remoteReferencesSection, null);
            return this.mergeValues(objectFieldValues, referencedObject.getFullRawObjectValues());
        }
        throw new UnexpectedConfigurationException(this.listName, "The list entry:" + this.compoundObjectName + " Is trying to default from: " + reference + " But that doesn't exist inside " + ConfigurationUtil.getSectionName(this.remoteReferencesSection));
    }

    private Map<String, Object> mergeValues(Map<String, Object> baseMap, Map<String, Object> mapToComplete) {
        for (String entry : mapToComplete.keySet()) {
            if (baseMap.containsKey(entry)) continue;
            baseMap.put(entry, mapToComplete.get(entry));
        }
        return baseMap;
    }

    @Override
    @Nullable
    public Object getField(@NotNull String fieldKey) throws IllegalArgumentException {
        if (this.fullRawObjectValues.containsKey(fieldKey)) {
            Object fieldValueAsObject = this.fullRawObjectValues.get(fieldKey);
            if (fieldValueAsObject instanceof String && ((String)fieldValueAsObject).startsWith("(copy:") && ((String)fieldValueAsObject).endsWith(")")) {
                ConfigurationSection referencedSection = null;
                String reference = (String)fieldValueAsObject;
                if (ConfigurationUtil.isLocalReferenceAttempt(reference = reference.substring(6, reference.length() - 1))) {
                    String exceptionText = "The list entry:" + this.compoundObjectName + " Inside: " + this.listName + " Is trying to copy its value from another list entry, but that is impossible";
                    if (this.remoteReferencesSection != null) {
                        exceptionText = exceptionText + "Please consider moving the object to " + ConfigurationUtil.getSectionName(this.remoteReferencesSection) + " In order to be able to copy values from it";
                    }
                    throw new IllegalArgumentException(exceptionText);
                }
                if (this.remoteReferencesSection != null && this.remoteReferencesSection.isConfigurationSection(reference)) {
                    referencedSection = this.remoteReferencesSection.getConfigurationSection(reference);
                }
                if (referencedSection != null) {
                    SectionBasedYmlObject referencedObject;
                    try {
                        referencedObject = new SectionBasedYmlObject(referencedSection, null, this.remoteReferencesSection, null);
                    }
                    catch (UnexpectedConfigurationException e) {
                        throw new IllegalArgumentException("Found reference: " + reference + " on the field: " + fieldKey + " but the refered object doesnt exist inside " + ConfigurationUtil.getSectionName(this.remoteReferencesSection));
                    }
                    return referencedObject.getField(fieldKey);
                }
            } else {
                return this.fullRawObjectValues.get(fieldKey);
            }
        }
        throw new NullPointerException("Field \"" + fieldKey + "\" Doesn't exist inside" + this.compoundObjectName);
    }
}

