/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.annotations.Creatable;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.ImpossibleTransformationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnlocatedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.TransformingUtil;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.Creator;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.YmlObject;
import com.github.onyxiansoul.damagepotioneffects.utils.ConfigurationUtil;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public abstract class Configurable {
    private final YmlObject originObject;

    public Configurable(YmlObject originObject) {
        this.originObject = originObject;
    }

    public final <T> T getField(String fieldName) throws UnlocatedConfigurationException {
        return this.getField(fieldName, null);
    }

    public final <T> T getField(String fieldName, T defaultValue) throws UnlocatedConfigurationException {
        String humanFieldName = ConfigurationUtil.getHumanFieldName(fieldName);
        try {
            Object ymlFieldValue = this.originObject.getField(humanFieldName);
            Field fieldOfInterest = this.getClass().getDeclaredField(fieldName);
            if (((Creatable[])fieldOfInterest.getDeclaredAnnotationsByType(Creatable.class)).length == 0) {
                TypeToken fieldType = TypeToken.of((Type)this.getClass().getDeclaredField(fieldName).getGenericType());
                return TransformingUtil.transformObject(fieldType, ymlFieldValue);
            }
            Class<? extends Creator> fieldCreator = fieldOfInterest.getAnnotation(Creatable.class).creator();
            if (fieldCreator != Creator.class) {
                return TransformingUtil.transformObject(TypeToken.of(fieldCreator), ymlFieldValue);
            }
            throw new UnlocatedConfigurationException("The field " + fieldOfInterest.toString() + " Has an invalid creator annotation. This is unexpected. Please report it ASAP.");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new UnlocatedConfigurationException("Could not find the class type of" + fieldName + ". This is unexpected, please report it ASAP.", e);
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new UnlocatedConfigurationException("Could not find the value of field:" + humanFieldName, e);
        }
        catch (NullPointerException e) {
            if (defaultValue == null) {
                throw new UnlocatedConfigurationException("Could not find the value of field:" + humanFieldName, e);
            }
            return defaultValue;
        }
        catch (ImpossibleTransformationException e) {
            throw new UnlocatedConfigurationException("The value of field " + humanFieldName + " is invalid.", e);
        }
    }
}

