/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.configurable;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnlocatedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.Configurable;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.YmlObject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public final class DamageBasedTrigger
extends Configurable {
    private final List<EntityType> affectedEntities = this.getField("affectedEntities", Arrays.asList(new EntityType[]{null}));
    private final List<EntityDamageEvent.DamageCause> damageCauses;
    private final double damageRequired;
    private final List<EntityType> attackerEntities = this.getField("attackerEntities", Arrays.asList(new EntityType[]{null}));

    public DamageBasedTrigger(YmlObject originObject) throws UnlocatedConfigurationException {
        super(originObject);
        this.damageCauses = this.getField("damageCauses", Arrays.asList(new EntityDamageEvent.DamageCause[]{null}));
        this.damageRequired = this.getField("damageRequired", 0.0);
    }

    public boolean areConditionsMet(EntityDamageEvent e) {
        return !(!(e.getDamage() > this.damageRequired) || !this.damageCauses.contains(e.getCause()) && !this.damageCauses.contains(null) || !this.affectedEntities.contains(e.getEntityType()) && !this.affectedEntities.contains(null) || !this.attackerEntities.contains(null) && (!(e instanceof EntityDamageByEntityEvent) || !this.attackerEntities.contains(((EntityDamageByEntityEvent)e).getDamager().getType())));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.affectedEntities);
        hash = 97 * hash + Objects.hashCode(this.damageCauses);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.damageRequired) ^ Double.doubleToLongBits(this.damageRequired) >>> 32);
        hash = 97 * hash + Objects.hashCode(this.attackerEntities);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DamageBasedTrigger other = (DamageBasedTrigger)obj;
        if (Double.doubleToLongBits(this.damageRequired) != Double.doubleToLongBits(other.damageRequired)) {
            return false;
        }
        if (!Objects.equals(this.affectedEntities, other.affectedEntities)) {
            return false;
        }
        if (!Objects.equals(this.damageCauses, other.damageCauses)) {
            return false;
        }
        return Objects.equals(this.attackerEntities, other.attackerEntities);
    }

    public String toString() {
        return "DamageBasedTrigger{affectedEntities=" + this.affectedEntities + ", damageCauses=" + this.damageCauses + ", damageRequired=" + this.damageRequired + ", attackerEntities=" + this.attackerEntities + "}";
    }
}

