/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.ImpossibleTransformationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.TransformingUtil;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.Transformer;
import com.google.common.reflect.TypeToken;
import java.util.LinkedList;
import java.util.List;

public class ListTransformer<T2>
implements Transformer<List<T2>> {
    private final TypeToken<T2> elementToken;

    public ListTransformer(TypeToken<T2> elementToken) {
        this.elementToken = elementToken;
    }

    @Override
    public List<T2> transform(Object object) throws ImpossibleTransformationException {
        List<Object> objectList;
        if (object instanceof List) {
            objectList = (List)List.class.cast(object);
        } else {
            objectList = new LinkedList();
            objectList.add(object);
        }
        LinkedList<T2> transformedList = new LinkedList<T2>();
        for (Object e : objectList) {
            transformedList.add(TransformingUtil.transformObject(this.elementToken, e));
        }
        return transformedList;
    }
}

