/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.ImpossibleTransformationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.TransformingUtil;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.Transformer;
import com.google.common.reflect.TypeToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumTransformer<T extends Enum<T>>
implements Transformer<T> {
    private final Class<T> enumClass;

    public EnumTransformer(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    @Nullable
    public T transform(@NotNull Object object) throws ImpossibleTransformationException {
        String objectAsS = ((String)TransformingUtil.transformObject(TypeToken.of(String.class), object)).toUpperCase();
        try {
            return Enum.valueOf(this.enumClass, objectAsS);
        }
        catch (IllegalArgumentException e) {
            if (objectAsS.equals("ANY")) {
                return null;
            }
            throw new ImpossibleTransformationException(this.enumClass.getSimpleName(), (Object)objectAsS, e);
        }
    }
}

