/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.ImpossibleTransformationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.DirectCastTransformer;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.DoubleTransformer;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.EnumTransformer;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.IntegerTransformer;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.ListTransformer;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.PotionEffectTypeTransformer;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.StringCrafter;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.transforming.transformers.Transformer;
import com.github.onyxiansoul.damagepotioneffects.utils.MessageUtil;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransformingUtil {
    private static final Map<String, Transformer> transformers = TransformingUtil.createTransformersIndex(StringCrafter.class, DoubleTransformer.class, IntegerTransformer.class, PotionEffectTypeTransformer.class);

    public static Map<String, Transformer> createTransformersIndex(Class<? extends Transformer> ... transformerClasses) {
        HashMap<String, Transformer> transformers = new HashMap<String, Transformer>();
        for (Class<? extends Transformer> transformerClass : transformerClasses) {
            try {
                Transformer transformerObject = transformerClass.newInstance();
                transformers.put(transformerObject.getT().getName(), transformerObject);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                MessageUtil.sendWarning("Failed to instantiate transformer: " + transformerClass.getName() + "The plugin may not work as expected. Please consider using a previous version and reporting this bug.");
            }
        }
        transformers.put("double", new DoubleTransformer());
        transformers.put("int", new IntegerTransformer());
        return transformers;
    }

    public static <T> T transformObject(TypeToken<T> typeRequired, Object object) throws ImpossibleTransformationException {
        Transformer<T> t = TransformingUtil.getTransformer(typeRequired);
        return t.transform(object);
    }

    private static <T> Transformer<T> getTransformer(TypeToken<T> classRequired) {
        if (transformers.containsKey(classRequired.getRawType().getName())) {
            return transformers.get(classRequired.getRawType().getName());
        }
        if (classRequired.getRawType().isEnum()) {
            return new EnumTransformer(classRequired.getRawType());
        }
        if (List.class.isAssignableFrom(classRequired.getRawType())) {
            ParameterizedType listType = (ParameterizedType)classRequired.getType();
            Type elementType = listType.getActualTypeArguments()[0];
            TypeToken elementToken = TypeToken.of((Type)elementType);
            return new ListTransformer(elementToken);
        }
        return new DirectCastTransformer(classRequired.getRawType());
    }
}

