/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration;

import com.github.onyxiansoul.damagepotioneffects.configuration.OnyxianConfiguration;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.SevereConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnexpectedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnlocatedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.DamageBasedTrigger;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.PotionEffectCreator;
import com.github.onyxiansoul.damagepotioneffects.utils.CollectionUtils;
import com.github.onyxiansoul.damagepotioneffects.utils.MessageUtil;
import com.google.common.collect.LinkedListMultimap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public final class PluginSettings {
    private final boolean bStatsEnabled;
    private final LinkedListMultimap<DamageBasedTrigger, PotionEffect> potionEffects;

    public PluginSettings(Plugin plugin) throws SevereConfigurationException {
        plugin.getDataFolder().mkdirs();
        OnyxianConfiguration mainConfig = this.createConfiguration(plugin, "config");
        OnyxianConfiguration damageTriggersC = this.createConfiguration(plugin, "Damage Triggers");
        OnyxianConfiguration potionEffectsC = this.createConfiguration(plugin, "Potion Effects");
        MessageUtil.setDebug(mainConfig.getBoolean("debug", false));
        this.bStatsEnabled = mainConfig.getBoolean("bStats", false);
        try {
            ConfigurationSection globalTriggersSection = damageTriggersC.getValidSection((ConfigurationSection)damageTriggersC, "damage triggers");
            ConfigurationSection globalEffectsSection = potionEffectsC.getValidSection((ConfigurationSection)potionEffectsC, "potion effects");
            ConfigurationSection relationsSection = mainConfig.getValidSection((ConfigurationSection)mainConfig, "damage reactions");
            this.potionEffects = CollectionUtils.getMapWithCreatedsValues(mainConfig.getRelationMap(relationsSection, DamageBasedTrigger.class, "damage triggers", globalTriggersSection, PotionEffectCreator.class, globalEffectsSection, "potion effects"));
        }
        catch (UnexpectedConfigurationException | UnlocatedConfigurationException e) {
            throw new SevereConfigurationException("Could not read a vital part of the configuration.", e);
        }
    }

    private OnyxianConfiguration createConfiguration(Plugin plugin, String name) throws SevereConfigurationException {
        try {
            return new OnyxianConfiguration(plugin, name);
        }
        catch (UnlocatedConfigurationException e) {
            throw new SevereConfigurationException("Could not read the config file: " + name, e);
        }
    }

    public boolean isbStatsEnabled() {
        return this.bStatsEnabled;
    }

    public LinkedListMultimap<DamageBasedTrigger, PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }
}

