/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects.configuration;

import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnexpectedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.base.exceptions.UnlocatedConfigurationException;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.Configurable;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.MapBasedYmlObject;
import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.structural.SectionBasedYmlObject;
import com.github.onyxiansoul.damagepotioneffects.utils.CollectionUtils;
import com.github.onyxiansoul.damagepotioneffects.utils.ConfigurationUtil;
import com.github.onyxiansoul.damagepotioneffects.utils.MessageUtil;
import com.google.common.collect.LinkedListMultimap;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class OnyxianConfiguration
extends YamlConfiguration {
    public OnyxianConfiguration(Plugin plugin, @NotNull String fileName) throws UnlocatedConfigurationException {
        String fileNameWithYml = fileName + ".yml";
        try {
            File configFile = new File(plugin.getDataFolder(), fileNameWithYml);
            if (!configFile.exists()) {
                plugin.saveResource(fileNameWithYml, false);
            }
            super.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new UnlocatedConfigurationException("Could not load the fie:" + fileNameWithYml, (Exception)e);
        }
    }

    public <T extends Configurable> T getConfigurableFromSection(Class<T> configurableType, ConfigurationSection compoundObjectSection, ConfigurationSection localReferencesSection, ConfigurationSection cousinSection) throws UnexpectedConfigurationException {
        SectionBasedYmlObject test = new SectionBasedYmlObject(compoundObjectSection, localReferencesSection, cousinSection, null);
        try {
            return test.createConfigurable(configurableType);
        }
        catch (UnlocatedConfigurationException e) {
            throw new UnexpectedConfigurationException(compoundObjectSection, ConfigurationUtil.getSectionName(compoundObjectSection) + " Is not a valid " + configurableType.getSimpleName(), (Exception)e);
        }
    }

    public <T extends Configurable> T getConfigurableFromListedMap(Class<T> configurableType, Map<String, Object> objectEntry, String listName, ConfigurationSection cousinSection) throws UnexpectedConfigurationException, UnlocatedConfigurationException {
        return new MapBasedYmlObject(objectEntry, listName, cousinSection).createConfigurable(configurableType);
    }

    public <T extends Configurable> List<T> getConfigurablesFromList(Class<T> configurableType, ConfigurationSection containingSection, String listName, ConfigurationSection cousinSection) throws UnexpectedConfigurationException, UnlocatedConfigurationException {
        List<?> listedObjects = this.getValidListOrWrap(containingSection, listName);
        LinkedList<T> createdConfigurables = new LinkedList<T>();
        for (Object listedObject : listedObjects) {
            if (listedObject instanceof Map) {
                createdConfigurables.add(this.getConfigurableFromListedMap(configurableType, CollectionUtils.safelyCastMap((Map)listedObject, String.class, Object.class), listName, cousinSection));
                continue;
            }
            String listedReference = listedObject instanceof String ? (String)listedObject : listedObject.toString();
            if (!ConfigurationUtil.isLocalReferenceAttempt(listedReference)) {
                if (cousinSection != null) {
                    if (cousinSection.isConfigurationSection(listedReference)) {
                        ConfigurationSection referencedSection = cousinSection.getConfigurationSection(listedReference);
                        createdConfigurables.add(this.getConfigurableFromSection(configurableType, referencedSection, null, cousinSection));
                        continue;
                    }
                    MessageUtil.sendWarning(new UnexpectedConfigurationException(listName, "The list contains a reference: \"" + listedReference + "\" that doesn't exist inside " + ConfigurationUtil.getSectionName(cousinSection)));
                    continue;
                }
                MessageUtil.sendWarning(new UnexpectedConfigurationException(listName, "The list contains a reference: \"" + listedReference + "\" , but there is no section where references of this type are stored."));
                continue;
            }
            String exceptionText = "The list entry: " + listedReference + " Is trying to reference another entry inside the list, but that is impossible";
            if (cousinSection != null) {
                exceptionText = exceptionText + "Please consider moving the object to " + cousinSection + " In order to be able to copy it";
            }
            MessageUtil.sendWarning(new UnexpectedConfigurationException(listName, exceptionText));
        }
        return createdConfigurables;
    }

    public <T extends Configurable> List<T> getConfigurablesFromSection(Class<T> configurableType, ConfigurationSection configurablesSection, ConfigurationSection cousinSection) throws UnexpectedConfigurationException, UnlocatedConfigurationException {
        LinkedList<T> createdConfigurables = new LinkedList<T>();
        for (String key : configurablesSection.getKeys(false)) {
            if (configurablesSection.isConfigurationSection(key)) {
                createdConfigurables.add(this.getConfigurableFromSection(configurableType, configurablesSection.getConfigurationSection(key), configurablesSection, cousinSection));
                continue;
            }
            String reference = configurablesSection.isString(key) ? configurablesSection.getString(key) : configurablesSection.get(key).toString();
            if (reference.startsWith("{local}")) {
                reference.substring(7);
                if (configurablesSection.isConfigurationSection(reference)) {
                    createdConfigurables.add(this.getConfigurableFromSection(configurableType, configurablesSection.getConfigurationSection(reference), configurablesSection, cousinSection));
                    continue;
                }
                throw new UnexpectedConfigurationException(configurablesSection, key + "contains a reference to another section inside the list: " + reference + " But it doesn't exist.");
            }
            if (cousinSection.isConfigurationSection(reference)) {
                createdConfigurables.add(this.getConfigurableFromSection(configurableType, cousinSection.getConfigurationSection(reference), null, cousinSection));
                continue;
            }
            throw new UnexpectedConfigurationException(configurablesSection, key + "contains a reference to another section inside the list: " + reference + " But it doesn't exist.");
        }
        return createdConfigurables;
    }

    private LinkedList<ConfigurationSection> getSubSections(ConfigurationSection parentSection) {
        LinkedList<ConfigurationSection> subSections = new LinkedList<ConfigurationSection>();
        Set parentSectionKeys = parentSection.getKeys(false);
        for (String parentSectionKey : parentSectionKeys) {
            if (!parentSection.isConfigurationSection(parentSectionKey)) continue;
            subSections.add(parentSection.getConfigurationSection(parentSectionKey));
        }
        return subSections;
    }

    @NotNull
    public <K extends Configurable, V extends Configurable> LinkedListMultimap<K, V> getRelationMap(ConfigurationSection relationsSection, Class<K> keyType, String keyName, ConfigurationSection kSection, Class<V> valueType, ConfigurationSection vSection, String valueName) throws UnlocatedConfigurationException {
        LinkedListMultimap relationMap = LinkedListMultimap.create();
        for (ConfigurationSection relationS : this.getSubSections(relationsSection)) {
            try {
                List<K> keys = this.getConfigurablesFromList(keyType, relationS, keyName, kSection);
                List<V> values = this.getConfigurablesFromList(valueType, relationS, valueName, vSection);
                for (Configurable key : keys) {
                    for (Configurable value : values) {
                        relationMap.put((Object)key, (Object)value);
                    }
                }
            }
            catch (UnexpectedConfigurationException e) {
                MessageUtil.sendWarning(e);
            }
        }
        return relationMap;
    }

    public ConfigurationSection getValidSection(ConfigurationSection parentSection, String key) throws UnexpectedConfigurationException {
        if (parentSection.isConfigurationSection(key)) {
            return parentSection.getConfigurationSection(key);
        }
        throw new UnexpectedConfigurationException(parentSection, ConfigurationUtil.getSectionName(parentSection) + " configuration section should contain a \"" + key + "\" section, but that isn't the case.");
    }

    private List<?> getValidListOrWrap(ConfigurationSection containingSection, String listName) throws UnexpectedConfigurationException {
        if (containingSection.isList(listName)) {
            return containingSection.getList(listName);
        }
        if (containingSection.contains(listName)) {
            LinkedList<Object> list = new LinkedList<Object>();
            list.add(containingSection.get(listName));
            return list;
        }
        throw new UnexpectedConfigurationException(containingSection, ConfigurationUtil.getSectionName(containingSection) + " configuration section should contain a \"" + listName + "\" list, but it doesn't contain" + listName + " At all.");
    }
}

