/*
 * Decompiled with CFR 0.152.
 */
package com.github.onyxiansoul.damagepotioneffects;

import com.github.onyxiansoul.damagepotioneffects.configuration.configurable.DamageBasedTrigger;
import com.google.common.collect.LinkedListMultimap;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.potion.PotionEffect;

final class DamageListener
implements Listener {
    private final LinkedListMultimap<DamageBasedTrigger, PotionEffect> potionEffects;
    private final Set<DamageBasedTrigger> damageBasedTriggers;

    DamageListener(LinkedListMultimap<DamageBasedTrigger, PotionEffect> potionEffects) {
        this.potionEffects = potionEffects;
        this.damageBasedTriggers = potionEffects.keySet();
    }

    @EventHandler
    public void onDamageEvent(EntityDamageEvent damageEvent) {
        if (damageEvent.getEntity() instanceof LivingEntity) {
            LivingEntity affectedEntity = (LivingEntity)damageEvent.getEntity();
            for (DamageBasedTrigger damageBasedTrigger : this.damageBasedTriggers) {
                if (!damageBasedTrigger.areConditionsMet(damageEvent)) continue;
                List effectsToApply = this.potionEffects.get((Object)damageBasedTrigger);
                for (PotionEffect potionEffect : effectsToApply) {
                    affectedEntity.addPotionEffect(potionEffect);
                }
            }
        }
    }
}

