/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.tags;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.internal.InternalUtils;
import me.ryandw11.ods.io.CountingOutputStream;

public class ObjectTag
implements Tag<List<Tag<?>>> {
    private String name;
    private List<Tag<?>> value;

    public ObjectTag(String name, List<Tag<?>> value) {
        this.name = name;
        this.value = value;
    }

    public ObjectTag(String name) {
        this.name = name;
        this.value = new ArrayList();
    }

    public void addTag(Tag<?> t) {
        this.value.add(t);
    }

    public Tag<?> getTag(String name) {
        List results = this.value.stream().filter(tag -> tag.getName().equals(name)).collect(Collectors.toList());
        if (results.size() < 1) {
            return null;
        }
        return (Tag)results.get(0);
    }

    public void removeTag(Tag<?> tag) {
        this.value.remove(tag);
    }

    public void removeTag(String name) {
        this.value.removeIf(tag -> tag.getName().equals(name));
    }

    public void removeAllTags() {
        this.value.clear();
    }

    public boolean hasTag(String name) {
        return this.value.stream().filter(tag -> tag.getName().equals(name)).collect(Collectors.toList()).size() > 0;
    }

    @Override
    public void setValue(List<Tag<?>> s) {
        this.value = s;
    }

    @Override
    public List<Tag<?>> getValue() {
        return this.value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.getID());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(os);
        DataOutputStream tempDos = new DataOutputStream(cos);
        tempDos.writeShort(this.name.getBytes(StandardCharsets.UTF_8).length);
        tempDos.write(this.name.getBytes(StandardCharsets.UTF_8));
        for (Tag<?> tag : this.value) {
            tag.writeData(tempDos);
        }
        dos.writeInt(cos.getCount());
        dos.write(os.toByteArray());
        tempDos.close();
    }

    @Override
    public Tag<List<Tag<?>>> createFromData(ByteBuffer value, int length) {
        List<Tag<?>> data = InternalUtils.getListData(value, length);
        this.value = data;
        return this;
    }

    @Override
    public byte getID() {
        return 11;
    }
}

