/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.tags;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.internal.InternalUtils;
import me.ryandw11.ods.io.CountingOutputStream;

public class MapTag<T extends Tag<?>>
implements Tag<Map<String, T>> {
    private String name;
    private Map<String, T> value;

    public MapTag(String name, Map<String, T> value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public void setValue(Map<String, T> s) {
        this.value = s;
    }

    @Override
    public Map<String, T> getValue() {
        return this.value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.getID());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(os);
        DataOutputStream tempDos = new DataOutputStream(cos);
        tempDos.writeShort(this.name.getBytes(StandardCharsets.UTF_8).length);
        tempDos.write(this.name.getBytes(StandardCharsets.UTF_8));
        for (Map.Entry<String, T> entry : this.value.entrySet()) {
            ((Tag)entry.getValue()).setName(entry.getKey());
            ((Tag)entry.getValue()).writeData(tempDos);
        }
        dos.writeInt(cos.getCount());
        dos.write(os.toByteArray());
        tempDos.close();
    }

    @Override
    public Tag<Map<String, T>> createFromData(ByteBuffer value, int length) {
        List<Tag<?>> data = InternalUtils.getListData(value, length);
        HashMap<String, T> output = new HashMap<String, T>();
        for (Tag<?> tag : data) {
            output.put(tag.getName(), tag);
            tag.setName("");
        }
        this.value = output;
        return this;
    }

    @Override
    public byte getID() {
        return 10;
    }
}

