/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.tags;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.internal.InternalUtils;
import me.ryandw11.ods.io.CountingOutputStream;

public class ListTag<T extends Tag<?>>
implements Tag<List<T>> {
    private String name;
    private List<T> value;

    public ListTag(String name, List<T> value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public void setValue(List<T> s) {
        this.value = s;
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addTag(T tag) {
        this.value.add(tag);
    }

    public T getTag(int i) {
        return (T)((Tag)this.value.get(i));
    }

    public void removeTag(T tag) {
        this.value.remove(tag);
    }

    public void removeTag(int i) {
        this.value.remove(i);
    }

    public void removeAllTags() {
        this.value.clear();
    }

    public int indexOf(T tag) {
        return this.value.indexOf(tag);
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.getID());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(os);
        DataOutputStream tempDos = new DataOutputStream(cos);
        tempDos.writeShort(this.name.getBytes(StandardCharsets.UTF_8).length);
        tempDos.write(this.name.getBytes(StandardCharsets.UTF_8));
        for (Tag tag : this.value) {
            tag.setName("");
            tag.writeData(tempDos);
        }
        dos.writeInt(cos.getCount());
        dos.write(os.toByteArray());
        tempDos.close();
    }

    @Override
    public Tag<List<T>> createFromData(ByteBuffer value, int length) {
        List<Tag<?>> data = InternalUtils.getListData(value, length);
        this.value = data.stream().map(d -> d).collect(Collectors.toList());
        return this;
    }

    @Override
    public byte getID() {
        return 9;
    }
}

