/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.tags;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.io.CountingOutputStream;

public class FloatTag
implements Tag<Float> {
    private String name;
    private Float value;

    public FloatTag(String name, float value) {
        this.name = name;
        this.value = Float.valueOf(value);
    }

    @Override
    public void setValue(Float s) {
        this.value = s;
    }

    @Override
    public Float getValue() {
        return this.value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.getID());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(os);
        DataOutputStream tempDos = new DataOutputStream(cos);
        tempDos.writeShort(this.name.getBytes(StandardCharsets.UTF_8).length);
        tempDos.write(this.name.getBytes(StandardCharsets.UTF_8));
        tempDos.writeFloat(this.value.floatValue());
        dos.writeInt(cos.getCount());
        dos.write(os.toByteArray());
        tempDos.close();
    }

    @Override
    public Tag<Float> createFromData(ByteBuffer value, int length) {
        this.value = Float.valueOf(value.getFloat());
        return this;
    }

    @Override
    public byte getID() {
        return 3;
    }
}

