/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.tags;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.ryandw11.ods.ODS;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.compression.Compressor;
import me.ryandw11.ods.compression.GZIPCompression;
import me.ryandw11.ods.exception.ODSException;
import me.ryandw11.ods.internal.InternalUtils;
import me.ryandw11.ods.io.CountingOutputStream;
import me.ryandw11.ods.io.ODSIOUtils;

public class CompressedObjectTag
implements Tag<List<Tag<?>>> {
    private String name;
    private Compressor compressor;
    private List<Tag<?>> value;

    public CompressedObjectTag(String name, List<Tag<?>> value, Compressor compressor) {
        this.name = name;
        this.value = value;
        this.compressor = compressor;
    }

    public CompressedObjectTag(String name, Compressor compressor) {
        this.name = name;
        this.compressor = compressor;
        this.value = new ArrayList();
    }

    public CompressedObjectTag(String name) {
        this(name, new ArrayList(), new GZIPCompression());
    }

    public void addTag(Tag<?> t) {
        this.value.add(t);
    }

    public Tag<?> getTag(String name) {
        List results = this.value.stream().filter(tag -> tag.getName().equals(name)).collect(Collectors.toList());
        if (results.size() < 1) {
            return null;
        }
        return (Tag)results.get(0);
    }

    public void removeTag(Tag<?> tag) {
        this.value.remove(tag);
    }

    public void removeTag(String name) {
        this.value.removeIf(tag -> tag.getName().equals(name));
    }

    public void removeAllTags() {
        this.value.clear();
    }

    public boolean hasTag(String name) {
        return this.value.stream().anyMatch(tag -> tag.getName().equals(name));
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public void setValue(List<Tag<?>> s) {
        this.value = s;
    }

    @Override
    public List<Tag<?>> getValue() {
        return this.value;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeData(DataOutputStream dos) throws IOException {
        dos.write(this.getID());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream(os);
        DataOutputStream tempDos = new DataOutputStream(cos);
        tempDos.writeShort(this.name.getBytes(StandardCharsets.UTF_8).length);
        tempDos.write(this.name.getBytes(StandardCharsets.UTF_8));
        String compressorName = ODS.getCompressorName(this.compressor);
        if (compressorName == null) {
            throw new ODSException("Unable to find compressor: " + this.compressor);
        }
        tempDos.writeShort(compressorName.getBytes(StandardCharsets.UTF_8).length);
        tempDos.write(compressorName.getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream osTemp = new ByteArrayOutputStream();
        OutputStream compressedStream = this.compressor.getOutputStream(osTemp);
        DataOutputStream tempDos2 = new DataOutputStream(compressedStream);
        for (Tag<?> tag : this.value) {
            tag.writeData(tempDos2);
        }
        tempDos2.close();
        tempDos.write(osTemp.toByteArray());
        dos.writeInt(cos.getCount());
        dos.write(os.toByteArray());
        tempDos.close();
    }

    @Override
    public Tag<List<Tag<?>>> createFromData(ByteBuffer value, int length) {
        short compressorLength = value.getShort();
        length -= 2 + compressorLength;
        byte[] compressorBytes = new byte[compressorLength];
        value.get(compressorBytes);
        String compressionName = new String(compressorBytes);
        Compressor compressor = ODS.getCompressor(compressionName);
        if (compressor == null) {
            throw new ODSException("Cannot find compressor: " + compressionName);
        }
        this.compressor = compressor;
        byte[] bitData = new byte[length];
        value.get(bitData);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(bitData);
            InputStream compressedInputStream = compressor.getInputStream(bis);
            ByteBuffer buffer = ByteBuffer.wrap(ODSIOUtils.toByteArray(compressedInputStream));
            bis.close();
            List<Tag<?>> data = InternalUtils.getListData(buffer, buffer.capacity());
            this.value = data;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new ODSException("An IO Error has occurred!", ex);
        }
        return this;
    }

    @Override
    public byte getID() {
        return 12;
    }
}

