/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.compression.Compressor;
import me.ryandw11.ods.exception.ODSException;
import me.ryandw11.ods.internal.InternalUtils;
import me.ryandw11.ods.internal.ODSInternal;
import me.ryandw11.ods.io.ODSIOUtils;
import me.ryandw11.ods.tags.ObjectTag;
import me.ryandw11.ods.util.KeyScout;
import me.ryandw11.ods.util.KeyScoutChild;

public class ODSMem
implements ODSInternal {
    private ByteBuffer memBuffer;

    public ODSMem(byte[] data, Compressor compressor) {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try {
            InputStream is = compressor.getInputStream(bis);
            this.memBuffer = ByteBuffer.wrap(ODSIOUtils.toByteArray(is));
        }
        catch (IOException ex) {
            throw new ODSException("Cannot decompress data.", ex);
        }
    }

    public ODSMem(ByteBuffer buffer, Compressor compressor) {
        ByteArrayInputStream bis = new ByteArrayInputStream(buffer.array());
        try {
            InputStream is = compressor.getInputStream(bis);
            this.memBuffer = ByteBuffer.wrap(ODSIOUtils.toByteArray(is));
        }
        catch (IOException ex) {
            throw new ODSException("Cannot decompress data.", ex);
        }
    }

    public ODSMem() {
        this.memBuffer = ByteBuffer.allocate(1);
    }

    private ByteBuffer getInputBuffer() {
        this.memBuffer.position(0);
        return this.memBuffer;
    }

    @Override
    public <T extends Tag<?>> T get(String key) {
        try {
            this.memBuffer.position(0);
            if (this.memBuffer.limit() == 1) {
                return null;
            }
            ByteBuffer buffer = this.getInputBuffer();
            Tag<?> out = InternalUtils.getSubObjectData(buffer, key);
            return (T)out;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid format or the buffer has been tampered with / corrupted.");
        }
    }

    @Override
    public List<Tag<?>> getAll() {
        try {
            if (this.memBuffer.limit() == 1) {
                return null;
            }
            ByteBuffer buffer = this.getInputBuffer();
            List<Tag<?>> output = InternalUtils.getListData(buffer, buffer.limit());
            return output;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid format or the buffer has been tampered with / corrupted.");
        }
    }

    @Override
    public void save(List<? extends Tag<?>> tags) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
            for (Tag<?> tag : tags) {
                tag.writeData(dos);
            }
            dos.close();
            os.close();
            this.memBuffer = ByteBuffer.wrap(os.toByteArray());
        }
        catch (IOException ex) {
            throw new ODSException("Error when saving information to the buffer", ex);
        }
    }

    @Override
    public void append(Tag<?> tag) {
        try {
            byte[] data = this.memBuffer.array();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
            dos.write(data);
            tag.writeData(dos);
            dos.close();
            os.close();
            this.memBuffer = ByteBuffer.wrap(data);
        }
        catch (IOException ex) {
            throw new ODSException("Error when saving information to the buffer", ex);
        }
    }

    @Override
    public void appendAll(List<Tag<?>> tags) {
        try {
            byte[] data = this.memBuffer.array();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
            dos.write(data);
            for (Tag<?> tag : tags) {
                tag.writeData(dos);
            }
            dos.close();
            this.memBuffer = ByteBuffer.wrap(os.toByteArray());
        }
        catch (IOException ex) {
            throw new ODSException("Error when saving information to the buffer", ex);
        }
    }

    @Override
    public boolean find(String key) {
        try {
            ByteBuffer buffer = this.getInputBuffer();
            return InternalUtils.findSubObjectData(buffer, key);
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid format or the buffer has been tampered with / corrupted.");
        }
    }

    @Override
    public boolean delete(String key) {
        try {
            ByteBuffer buffer = this.getInputBuffer();
            KeyScout counter = InternalUtils.scoutObjectData(buffer, key, new KeyScout());
            if (counter == null) {
                return false;
            }
            byte[] deleteReturn = InternalUtils.deleteSubObjectData(buffer.array(), counter);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(deleteReturn);
            this.memBuffer = ByteBuffer.wrap(out.toByteArray());
            out.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid format or the buffer has been tampered with / corrupted.");
        }
    }

    @Override
    public boolean replaceData(String key, Tag<?> replacement) {
        try {
            ByteBuffer buffer = this.getInputBuffer();
            KeyScout counter = InternalUtils.scoutObjectData(buffer, key, new KeyScout());
            if (counter.getEnd() == null) {
                return false;
            }
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteArrayOut);
            replacement.writeData(dos);
            byte[] replaceReturn = InternalUtils.replaceSubObjectData(buffer.array(), counter, byteArrayOut.toByteArray());
            this.memBuffer = ByteBuffer.wrap(replaceReturn);
            dos.close();
            byteArrayOut.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public void set(String key, Tag<?> value) {
        if (value == null) {
            boolean output = this.delete(key);
            if (!output) {
                throw new ODSException("The key " + key + " does not exist!");
            }
            return;
        }
        if (key.equals("")) {
            this.save(Collections.singletonList(value));
            return;
        }
        try {
            ByteBuffer buffer = this.getInputBuffer();
            KeyScout counter = InternalUtils.scoutObjectData(buffer, key, new KeyScout());
            if (counter.getEnd() == null) {
                Tag<?> currentData;
                if (counter.getChildren().size() < 1) {
                    this.append(value);
                    return;
                }
                StringBuilder existingKey = new StringBuilder();
                for (KeyScoutChild child : counter.getChildren()) {
                    if (existingKey.length() != 0) {
                        existingKey.append(".");
                    }
                    existingKey.append(child.getName());
                }
                String newKey = key.replace(existingKey + ".", "");
                if (newKey.split("\\.").length > 1) {
                    ObjectTag output = null;
                    ObjectTag curTag = null;
                    ArrayList<String> keys = new ArrayList<String>(Arrays.asList(newKey.split("\\.")));
                    int i = 0;
                    for (String s : keys) {
                        if (i == 0) {
                            curTag = output = new ObjectTag(s);
                        } else if (i == keys.size() - 1) {
                            curTag.addTag(value);
                        } else {
                            ObjectTag tag = new ObjectTag(s);
                            curTag.addTag(tag);
                            curTag = tag;
                        }
                        ++i;
                    }
                    currentData = output;
                } else {
                    currentData = value;
                }
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(byteArrayOut);
                assert (currentData != null);
                currentData.writeData(dos);
                byte[] data = byteArrayOut.toByteArray();
                dos.close();
                byteArrayOut.close();
                byte[] output = InternalUtils.setSubObjectData(this.memBuffer.array(), counter, data);
                this.memBuffer = ByteBuffer.wrap(output);
            } else {
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(byteArrayOut);
                value.writeData(dos);
                byte[] replaceReturn = InternalUtils.replaceSubObjectData(buffer.array(), counter, byteArrayOut.toByteArray());
                this.memBuffer = ByteBuffer.wrap(replaceReturn);
                dos.close();
                byteArrayOut.close();
            }
        }
        catch (IOException ex) {
            throw new ODSException("An error had occurred when trying to set data. Does that key exist?", ex);
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid format or the buffer has been tampered with / corrupted.");
        }
    }

    @Override
    public byte[] export(Compressor compressor) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            OutputStream os = compressor.getOutputStream(bos);
            os.write(this.memBuffer.array());
            byte[] output = bos.toByteArray();
            os.close();
            return output;
        }
        catch (IOException ex) {
            throw new ODSException("Unable to export bytes from memory.", ex);
        }
    }

    @Override
    public void importFile(File file, Compressor compressor) {
        try (InputStream is = compressor.getInputStream(new FileInputStream(file));){
            byte[] data = ODSIOUtils.toByteArray(is);
            this.memBuffer = ByteBuffer.wrap(data);
        }
        catch (IOException ex) {
            throw new ODSException("Unable to import bytes from files.", ex);
        }
    }

    @Override
    public void saveToFile(File file, Compressor compressor) {
        try (OutputStream fos = compressor.getOutputStream(new FileOutputStream(file));){
            fos.write(this.memBuffer.array());
        }
        catch (IOException ex) {
            throw new ODSException("Unable to export bytes to file.", ex);
        }
    }

    @Override
    public void clear() {
        this.memBuffer.clear();
    }
}

