/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterOutputStream;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.compression.Compressor;
import me.ryandw11.ods.exception.ODSException;
import me.ryandw11.ods.internal.InternalUtils;
import me.ryandw11.ods.internal.ODSInternal;
import me.ryandw11.ods.io.ODSIOUtils;
import me.ryandw11.ods.tags.ObjectTag;
import me.ryandw11.ods.util.KeyScout;
import me.ryandw11.ods.util.KeyScoutChild;

public class ODSFile
implements ODSInternal {
    private final File file;
    private final Compressor compression;

    public ODSFile(File file, Compressor compression) {
        this.file = file;
        this.compression = compression;
    }

    private OutputStream getOutputStream() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        return this.compression.getOutputStream(fos);
    }

    private InputStream getInputStream() throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        return this.compression.getInputStream(fis);
    }

    private ByteBuffer getInputBuffer(InputStream stream) throws IOException {
        if (stream instanceof FileInputStream) {
            try (FileInputStream fis = (FileInputStream)stream;){
                FileChannel channel = fis.getChannel();
                MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                return mappedByteBuffer;
            }
        }
        return ByteBuffer.wrap(ODSIOUtils.toByteArray(stream));
    }

    @Override
    public <T extends Tag<?>> T get(String key) {
        try {
            if (!this.file.exists()) {
                return null;
            }
            InputStream is = this.getInputStream();
            ByteBuffer buffer = this.getInputBuffer(is);
            Tag<?> out = InternalUtils.getSubObjectData(buffer, key);
            buffer.clear();
            return (T)out;
        }
        catch (IOException ex) {
            throw new ODSException("Error when receiving information from a file.", ex);
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public List<Tag<?>> getAll() {
        try {
            if (!this.file.exists()) {
                return null;
            }
            InputStream is = this.getInputStream();
            ByteBuffer buffer = this.getInputBuffer(is);
            List<Tag<?>> output = InternalUtils.getListData(buffer, buffer.limit());
            is.close();
            return output;
        }
        catch (IOException ex) {
            throw new ODSException("Error when receiving information from a file.", ex);
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public void save(List<? extends Tag<?>> tags) {
        try {
            OutputStream os = this.getOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
            for (Tag<?> tag : tags) {
                tag.writeData(dos);
            }
            dos.close();
            os.close();
        }
        catch (IOException ex) {
            throw new ODSException("Error when saving information to the file", ex);
        }
    }

    @Override
    public void append(Tag<?> tag) {
        try {
            byte[] data = new byte[]{};
            if (!this.file.exists()) {
                if (!this.file.createNewFile()) {
                    throw new ODSException("Unable to create file when appending tag.");
                }
            } else {
                InputStream is = this.getInputStream();
                data = ODSIOUtils.toByteArray(is);
                is.close();
            }
            OutputStream os = this.getOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
            dos.write(data);
            tag.writeData(dos);
            dos.close();
            os.close();
            this.finish(os);
        }
        catch (IOException ex) {
            throw new ODSException("Error when saving information to the file", ex);
        }
    }

    @Override
    public void appendAll(List<Tag<?>> tags) {
        try {
            byte[] data = new byte[]{};
            if (!this.file.exists()) {
                if (!this.file.createNewFile()) {
                    throw new ODSException("Unable to create file when appending all tags.");
                }
            } else {
                InputStream is = this.getInputStream();
                data = ODSIOUtils.toByteArray(is);
                is.close();
            }
            OutputStream os = this.getOutputStream();
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(os));
            dos.write(data);
            for (Tag<?> tag : tags) {
                tag.writeData(dos);
            }
            dos.close();
            this.finish(os);
        }
        catch (IOException ex) {
            throw new ODSException("Error when saving information to the file", ex);
        }
    }

    @Override
    public boolean find(String key) {
        try {
            InputStream is = this.getInputStream();
            ByteBuffer buffer = this.getInputBuffer(is);
            return InternalUtils.findSubObjectData(buffer, key);
        }
        catch (IOException ex) {
            return false;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public boolean delete(String key) {
        try {
            InputStream is = this.getInputStream();
            ByteBuffer buffer = this.getInputBuffer(is);
            is.close();
            KeyScout counter = InternalUtils.scoutObjectData(buffer, key, new KeyScout());
            if (counter == null) {
                return false;
            }
            byte[] deleteReturn = InternalUtils.deleteSubObjectData(buffer.array(), counter);
            OutputStream out = this.getOutputStream();
            out.write(deleteReturn);
            out.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public boolean replaceData(String key, Tag<?> replacement) {
        try {
            InputStream is = this.getInputStream();
            ByteBuffer buffer = this.getInputBuffer(is);
            is.close();
            KeyScout counter = InternalUtils.scoutObjectData(buffer, key, new KeyScout());
            if (counter.getEnd() == null) {
                return false;
            }
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(byteArrayOut);
            replacement.writeData(dos);
            byte[] replaceReturn = InternalUtils.replaceSubObjectData(buffer.array(), counter, byteArrayOut.toByteArray());
            OutputStream out = this.getOutputStream();
            out.write(replaceReturn);
            out.close();
            dos.close();
            byteArrayOut.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public void set(String key, Tag<?> value) {
        if (value == null) {
            boolean output = this.delete(key);
            if (!output) {
                throw new ODSException("The key " + key + " does not exist!");
            }
            return;
        }
        if (key.equals("")) {
            this.save(Collections.singletonList(value));
            return;
        }
        try {
            InputStream is = this.getInputStream();
            ByteBuffer buffer = this.getInputBuffer(is);
            is.close();
            KeyScout counter = InternalUtils.scoutObjectData(buffer, key, new KeyScout());
            if (counter.getEnd() == null) {
                Tag<?> currentData;
                if (counter.getChildren().size() < 1) {
                    this.append(value);
                    return;
                }
                StringBuilder existingKey = new StringBuilder();
                for (KeyScoutChild child : counter.getChildren()) {
                    if (existingKey.length() != 0) {
                        existingKey.append(".");
                    }
                    existingKey.append(child.getName());
                }
                String newKey = key.replace(existingKey + ".", "");
                if (newKey.split("\\.").length > 1) {
                    ObjectTag output = null;
                    ObjectTag curTag = null;
                    ArrayList<String> keys = new ArrayList<String>(Arrays.asList(newKey.split("\\.")));
                    int i = 0;
                    for (String s : keys) {
                        if (i == 0) {
                            curTag = output = new ObjectTag(s);
                        } else if (i == keys.size() - 1) {
                            curTag.addTag(value);
                        } else {
                            ObjectTag tag = new ObjectTag(s);
                            curTag.addTag(tag);
                            curTag = tag;
                        }
                        ++i;
                    }
                    currentData = output;
                } else {
                    currentData = value;
                }
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(byteArrayOut);
                assert (currentData != null);
                currentData.writeData(dos);
                byte[] data = byteArrayOut.toByteArray();
                dos.close();
                byteArrayOut.close();
                InputStream stream = this.getInputStream();
                byte[] output = InternalUtils.setSubObjectData(ODSIOUtils.toByteArray(stream), counter, data);
                stream.close();
                OutputStream out = this.getOutputStream();
                out.write(output);
                out.close();
            } else {
                ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(byteArrayOut);
                value.writeData(dos);
                byte[] replaceReturn = InternalUtils.replaceSubObjectData(buffer.array(), counter, byteArrayOut.toByteArray());
                OutputStream out = this.getOutputStream();
                out.write(replaceReturn);
                out.close();
                dos.close();
                byteArrayOut.close();
            }
        }
        catch (IOException ex) {
            throw new ODSException("An error had occurred when trying to set data. Does that key exist?", ex);
        }
        catch (BufferOverflowException | BufferUnderflowException ex) {
            throw new ODSException("Invalid file format or the file has been tampered with / corrupted.");
        }
    }

    @Override
    public byte[] export(Compressor compressor) {
        try {
            InputStream io = this.getInputStream();
            byte[] data = ODSIOUtils.toByteArray(io);
            io.close();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream os = compressor.getOutputStream(bos);
            os.write(data);
            byte[] output = bos.toByteArray();
            os.close();
            return output;
        }
        catch (IOException ex) {
            throw new ODSException("Unable to export data from file.", ex);
        }
    }

    @Override
    public void importFile(File file, Compressor compressor) {
        try (InputStream is = compressor.getInputStream(new FileInputStream(file));){
            byte[] data = ODSIOUtils.toByteArray(is);
            try (OutputStream fos = this.compression.getOutputStream(new FileOutputStream(this.file));){
                fos.write(data);
            }
            catch (IOException ex) {
                throw new ODSException("Unable to export bytes to file.", ex);
            }
        }
        catch (IOException ex) {
            throw new ODSException("Unable to import bytes from files.", ex);
        }
    }

    @Override
    public void saveToFile(File file, Compressor compressor) {
        try (InputStream is = this.compression.getInputStream(new FileInputStream(this.file));){
            byte[] data = ODSIOUtils.toByteArray(is);
            try (OutputStream fos = compressor.getOutputStream(new FileOutputStream(file));){
                fos.write(data);
            }
            catch (IOException ex) {
                throw new ODSException("Unable to export bytes to file.", ex);
            }
        }
        catch (IOException ex) {
            throw new ODSException("Unable to import bytes from files.", ex);
        }
    }

    @Override
    public void clear() {
        try {
            if (!this.file.createNewFile()) {
                throw new ODSException("Unable to clear file. Does the file have the correct permission?");
            }
        }
        catch (IOException ex) {
            throw new ODSException("IO error occurred when clearing the file.", ex);
        }
    }

    private void finish(OutputStream stream) {
        try {
            if (stream instanceof GZIPOutputStream) {
                ((GZIPOutputStream)stream).finish();
            }
            if (stream instanceof InflaterOutputStream) {
                ((InflaterOutputStream)stream).finish();
            }
        }
        catch (IOException ex) {
            throw new ODSException("An error has occurred while attempting to close the output stream of the file.", ex);
        }
    }
}

