/*
 * Decompiled with CFR 0.152.
 */
package me.ryandw11.ods;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.ryandw11.ods.Tag;
import me.ryandw11.ods.compression.Compressor;
import me.ryandw11.ods.compression.GZIPCompression;
import me.ryandw11.ods.compression.ZLIBCompression;
import me.ryandw11.ods.exception.ODSException;
import me.ryandw11.ods.serializer.Serializable;
import me.ryandw11.ods.tags.ByteTag;
import me.ryandw11.ods.tags.CharTag;
import me.ryandw11.ods.tags.DoubleTag;
import me.ryandw11.ods.tags.FloatTag;
import me.ryandw11.ods.tags.IntTag;
import me.ryandw11.ods.tags.ListTag;
import me.ryandw11.ods.tags.LongTag;
import me.ryandw11.ods.tags.ObjectTag;
import me.ryandw11.ods.tags.ShortTag;
import me.ryandw11.ods.tags.StringTag;

public class ODS {
    protected static boolean ignoreInvalidCustomTags = false;
    private static final List<Tag<?>> customTags = new ArrayList();
    private static final Map<String, Compressor> compressorMap = new HashMap<String, Compressor>();

    private ODS() {
    }

    public static Tag<?> wrap(Object o) {
        return ODS.wrap("", o);
    }

    public static Tag<?> wrap(String name, Object o) {
        if (o instanceof Byte) {
            return new ByteTag(name, (Byte)o);
        }
        if (o instanceof Character) {
            return new CharTag(name, ((Character)o).charValue());
        }
        if (o instanceof Double) {
            return new DoubleTag(name, (Double)o);
        }
        if (o instanceof Float) {
            return new FloatTag(name, ((Float)o).floatValue());
        }
        if (o instanceof Integer) {
            return new IntTag(name, (Integer)o);
        }
        if (o instanceof Long) {
            return new LongTag(name, (Long)o);
        }
        if (o instanceof Short) {
            return new ShortTag(name, (Short)o);
        }
        if (o instanceof String) {
            return new StringTag(name, (String)o);
        }
        if (o instanceof List) {
            return ODS.wrap(name, (List)o);
        }
        return ODS.serialize(name, o);
    }

    public static <T> T unwrap(Tag<T> tag) {
        if (tag instanceof ObjectTag) {
            try {
                ObjectTag objTag = (ObjectTag)tag;
                String clazzName = (String)objTag.getTag("ODS_TAG").getValue();
                if (clazzName == null) {
                    throw new RuntimeException("Cannot unwrap object: TagObject is not a serialized object!");
                }
                return (T)ODS.deserialize(tag, Class.forName(clazzName));
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        return tag.getValue();
    }

    public static <T> ListTag<?> wrap(String name, List<T> list) {
        ArrayList output = new ArrayList();
        for (T t : list) {
            output.add(ODS.wrap(t));
        }
        return new ListTag(name, output);
    }

    public static <T> List<Tag<?>> wrap(List<T> list) {
        ArrayList output = new ArrayList();
        for (T t : list) {
            output.add(ODS.wrap(t));
        }
        return output;
    }

    public static <T> List<T> unwrapList(List<Tag<T>> tags) {
        ArrayList<T> output = new ArrayList<T>();
        for (Tag<T> tag : tags) {
            output.add(ODS.unwrap(tag));
        }
        return output;
    }

    public static <T> List<T> unwrapListTag(ListTag<? extends Tag<T>> list) {
        ArrayList<T> output = new ArrayList<T>();
        Iterator iterator = list.getValue().iterator();
        while (iterator.hasNext()) {
            Tag tag = (Tag)iterator.next();
            output.add(ODS.unwrap(tag));
        }
        return output;
    }

    public static ObjectTag serialize(String key, Object obj) {
        ObjectTag objectTag = new ObjectTag(key);
        try {
            Class<?> clazz = obj.getClass();
            objectTag.addTag(new StringTag("ODS_TAG", clazz.getName()));
            for (Field f : clazz.getDeclaredFields()) {
                if (f.getAnnotation(Serializable.class) == null) continue;
                f.setAccessible(true);
                objectTag.addTag(ODS.wrap(f.getName(), f.get(obj)));
                f.setAccessible(false);
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        if (objectTag.getValue().size() < 2) {
            throw new RuntimeException("Cannot serialize object: No serializable fields detected!");
        }
        return objectTag;
    }

    public static <T> T deserialize(Tag<?> tag, Class<T> mainClazz) {
        T obj;
        if (!(tag instanceof ObjectTag)) {
            throw new RuntimeException("Cannot deserialize tag: Tag is not an ObjectTag!");
        }
        ObjectTag objectTag = (ObjectTag)tag;
        if (!objectTag.hasTag("ODS_TAG")) {
            throw new RuntimeException("Cannot deserialize tag: This tag was not serialized!");
        }
        try {
            obj = mainClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        for (Field f : mainClazz.getDeclaredFields()) {
            if (f.getAnnotation(Serializable.class) == null) continue;
            try {
                f.setAccessible(true);
                f.set(obj, ODS.unwrap(objectTag.getTag(f.getName())));
                f.setAccessible(false);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return obj;
    }

    public static void registerCustomTag(Tag<?> tag) {
        if (tag.getID() > -1 && tag.getID() < 15) {
            throw new ODSException("Invalid Tag ID. ID cannot be 0 - 15");
        }
        customTags.add(tag);
    }

    public static void registerCompression(String name, Compressor compressor) {
        compressorMap.put(name, compressor);
    }

    public static Compressor getCompressor(String name) {
        return compressorMap.get(name);
    }

    public static String getCompressorName(Compressor compressor) {
        for (Map.Entry<String, Compressor> entry : compressorMap.entrySet()) {
            if (entry.getValue().getClass() != compressor.getClass()) continue;
            return entry.getKey();
        }
        return null;
    }

    public static List<Tag<?>> getCustomTags() {
        return customTags;
    }

    public static void allowUndefinedTags(boolean value) {
        ignoreInvalidCustomTags = value;
    }

    static {
        compressorMap.put("GZIP", new GZIPCompression());
        compressorMap.put("ZLIB", new ZLIBCompression());
    }
}

