/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties.schematics;

import com.ryandw11.structure.utils.NumberStylizer;
import com.ryandw11.structure.utils.Pair;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.Nullable;

public class VerticalRepositioning {
    private final String range;
    private final String spawnY;
    private final HeightMap spawnYHeightMap;
    private final String noPointSolution;

    public VerticalRepositioning(String sectionName, ConfigurationSection section) {
        this.range = section.contains("Range") ? section.getString("Range") : "";
        if (!section.contains("SpawnY")) {
            throw new RuntimeException(String.format("Unable to find SpawnY section for sub-schematic %s!", sectionName));
        }
        this.spawnY = section.getString("SpawnY");
        this.spawnYHeightMap = section.contains("SpawnYHeightMap") ? HeightMap.valueOf((String)section.getString("SpawnYHeightMap").toUpperCase()) : HeightMap.WORLD_SURFACE;
        this.noPointSolution = section.contains("NoPointSolution") ? section.getString("NoPointSolution") : "CURRENT";
    }

    public VerticalRepositioning(String range, String spawnY, HeightMap heightMap, String noPointSolution) {
        this.range = range;
        this.spawnY = spawnY;
        this.spawnYHeightMap = heightMap;
        this.noPointSolution = noPointSolution;
    }

    @Nullable
    public Pair<Integer, Integer> getRange() {
        if (this.range.isEmpty()) {
            return null;
        }
        return NumberStylizer.parseRangedInput(this.range);
    }

    public String getRawSpawnY() {
        return this.spawnY;
    }

    public int getSpawnY(@Nullable Location location) {
        return NumberStylizer.getStylizedSpawnY(this.spawnY, location);
    }

    public HeightMap getSpawnYHeightMap() {
        return this.spawnYHeightMap;
    }

    public String getNoPointSolution() {
        return this.noPointSolution;
    }
}

