/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.structure.properties.schematics.SubSchematic;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class SubSchematics {
    private boolean enabled;
    private List<SubSchematic> schematics;

    public SubSchematics(@NotNull FileConfiguration configuration, @NotNull CustomStructures plugin) {
        this.schematics = new ArrayList<SubSchematic>();
        if (!configuration.contains("SubSchematics")) {
            this.enabled = false;
            return;
        }
        ConfigurationSection section = configuration.getConfigurationSection("SubSchematics");
        assert (section != null);
        try {
            for (String s : section.getKeys(false)) {
                this.schematics.add(new SubSchematic(Objects.requireNonNull(section.getConfigurationSection(s)), false));
            }
        }
        catch (RuntimeException ex) {
            this.enabled = false;
            plugin.getLogger().warning("Unable to enable SubStructures on structure " + configuration.getName() + ".");
            plugin.getLogger().warning("The following error occurred:");
            plugin.getLogger().warning(ex.getMessage());
        }
        this.enabled = true;
    }

    public SubSchematics(boolean enabled) {
        this.enabled = enabled;
        this.schematics = new ArrayList<SubSchematic>();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<SubSchematic> getSchematics() {
        return this.schematics;
    }

    public void setSchematics(List<SubSchematic> schematics) {
        this.schematics = schematics;
    }

    public void addSchematic(SubSchematic subSchematic) {
        this.schematics.add(subSchematic);
    }
}

