/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties;

import com.ryandw11.structure.exceptions.StructureConfigurationException;
import com.ryandw11.structure.structure.StructureBuilder;
import com.ryandw11.structure.structure.properties.StructureProperty;
import com.ryandw11.structure.structure.properties.StructureYSpawning;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.HeightMap;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class StructureLocation
implements StructureProperty {
    private List<String> worlds;
    private StructureYSpawning spawnY;
    private List<String> biomes;
    private double distanceFromOthers;
    private double distanceFromSame;
    private int xLimitation;
    private int zLimitation;

    @Deprecated
    public StructureLocation(StructureBuilder sb, FileConfiguration configuration) {
        this(configuration);
    }

    public StructureLocation(FileConfiguration fileConfiguration) {
        ConfigurationSection cs = fileConfiguration.getConfigurationSection("StructureLocation");
        if (cs == null) {
            throw new StructureConfigurationException("The `StructureLocation` property is mandatory, please add one to the file for the structure to be valid.");
        }
        this.worlds = cs.contains("Worlds") ? cs.getStringList("Worlds") : new ArrayList<String>();
        this.spawnY = new StructureYSpawning(fileConfiguration);
        this.biomes = cs.contains("Biome") ? cs.getStringList("Biome") : new ArrayList<String>();
        this.distanceFromOthers = cs.contains("DistanceFromOthers") ? Math.max(0.0, cs.getDouble("DistanceFromOthers")) : 100.0;
        this.distanceFromSame = cs.contains("DistanceFromSame") ? Math.max(0.0, cs.getDouble("DistanceFromSame")) : 100.0;
        this.xLimitation = 0;
        this.zLimitation = 0;
        if (cs.contains("SpawnDistance.x")) {
            this.xLimitation = cs.getInt("SpawnDistance.x");
        }
        if (cs.contains("SpawnDistance.z")) {
            this.zLimitation = cs.getInt("SpawnDistance.z");
        }
    }

    public StructureLocation(List<String> worlds, StructureYSpawning spawnSettings, List<String> biomes) {
        this.worlds = worlds;
        this.spawnY = spawnSettings;
        this.biomes = biomes;
        this.distanceFromOthers = 100.0;
        this.distanceFromSame = 100.0;
        this.xLimitation = 0;
        this.zLimitation = 0;
    }

    public StructureLocation() {
        this(new ArrayList<String>(), new StructureYSpawning("top", HeightMap.WORLD_SURFACE, true), new ArrayList<String>());
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public StructureYSpawning getSpawnSettings() {
        return this.spawnY;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public void setWorlds(List<String> worlds) {
        this.worlds = worlds;
    }

    public void setSpawnSettings(StructureYSpawning spawnY) {
        this.spawnY = spawnY;
    }

    public void setBiomes(List<String> biomes) {
        this.biomes = biomes;
    }

    public boolean hasBiome(Biome b) {
        if (this.biomes.isEmpty()) {
            return true;
        }
        for (String biome : this.biomes) {
            if (!b.toString().equalsIgnoreCase(biome.replace("minecraft:", ""))) continue;
            return true;
        }
        return false;
    }

    public void setXLimitation(int x) {
        this.xLimitation = x;
    }

    public int getXLimitation() {
        return this.xLimitation;
    }

    public void setZLimitation(int z) {
        this.zLimitation = z;
    }

    public int getZLimitation() {
        return this.zLimitation;
    }

    public double getDistanceFromOthers() {
        return this.distanceFromOthers;
    }

    public void setDistanceFromOthers(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance must be greater than 0!");
        }
        this.distanceFromOthers = distance;
    }

    public double getDistanceFromSame() {
        return this.distanceFromSame;
    }

    public void setDistanceFromSame(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance must be greater than 0!");
        }
        this.distanceFromSame = distance;
    }

    @Override
    public void saveToFile(ConfigurationSection configurationSection) {
        configurationSection.set("Worlds", this.worlds);
        configurationSection.set("SpawnY", (Object)this.spawnY.getValue());
        configurationSection.set("SpawnYHeightMap", (Object)this.spawnY.getHeightMap().toString());
        configurationSection.set("Biome", this.biomes);
        configurationSection.set("DistanceFromOthers", (Object)this.distanceFromOthers);
        if (this.xLimitation > 0) {
            configurationSection.set("SpawnDistance.x", (Object)this.xLimitation);
        }
        if (this.zLimitation > 0) {
            configurationSection.set("SpawnDistance.z", (Object)this.zLimitation);
        }
    }
}

