/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties;

import com.ryandw11.structure.structure.properties.BlockLevelLimit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;

public class StructureLimitations {
    private int worldHeightRestriction;
    private int iterationLimit;
    private final List<String> whitelistSpawnBlocks;
    private final List<String> blacklistSpawnBlocks;
    private final BlockLevelLimit blockLevelLimit;
    private final Map<Material, Material> blockReplacement;
    private double replacementBlocksDelay;

    public StructureLimitations(FileConfiguration configuration) {
        this.iterationLimit = !configuration.contains("StructureLimitations.IterationLimit") ? 2 : configuration.getInt("StructureLimitations.IterationLimit");
        this.worldHeightRestriction = !configuration.contains("StructureLimitations.WorldHeightRestriction") ? -1 : Math.max(0, configuration.getInt("StructureLimitations.WorldHeightRestriction"));
        this.whitelistSpawnBlocks = !configuration.contains("StructureLimitations.WhitelistSpawnBlocks") ? new ArrayList<String>() : configuration.getStringList("StructureLimitations.WhitelistSpawnBlocks");
        this.blacklistSpawnBlocks = !configuration.contains("StructureLimitations.BlacklistSpawnBlocks") ? new ArrayList<String>() : configuration.getStringList("StructureLimitations.BlacklistSpawnBlocks");
        this.blockLevelLimit = new BlockLevelLimit(configuration);
        this.replacementBlocksDelay = !configuration.contains("StructureLimitations.ReplaceBlockDelay") ? 0.0 : configuration.getDouble("StructureLimitations.ReplaceBlockDelay");
        this.blockReplacement = new HashMap<Material, Material>();
        if (configuration.contains("StructureLimitations.replacement_blocks")) {
            for (String s : Objects.requireNonNull(configuration.getConfigurationSection("StructureLimitations.ReplaceBlocks")).getKeys(false)) {
                Material firstMaterial = Material.getMaterial((String)s);
                Material secondMaterial = Material.getMaterial((String)Objects.requireNonNull(configuration.getString("StructureLimitations.ReplaceBlocks." + s)));
                this.blockReplacement.put(firstMaterial, secondMaterial);
            }
        }
    }

    public StructureLimitations(List<String> whitelistSpawnBlocks, List<String> blacklistSpawnBlocks, BlockLevelLimit blockLevelLimit, Map<Material, Material> blockReplacement) {
        this.iterationLimit = 2;
        this.worldHeightRestriction = -1;
        this.whitelistSpawnBlocks = whitelistSpawnBlocks;
        this.blacklistSpawnBlocks = blacklistSpawnBlocks;
        this.blockLevelLimit = blockLevelLimit;
        this.blockReplacement = blockReplacement;
    }

    public void setIterationLimit(int iterationLimit) {
        this.iterationLimit = iterationLimit;
    }

    public int getIterationLimit() {
        return this.iterationLimit;
    }

    public List<String> getWhitelistBlocks() {
        return this.whitelistSpawnBlocks;
    }

    public List<String> getBlacklistBlocks() {
        return this.blacklistSpawnBlocks;
    }

    public boolean hasWhitelistBlock(Block b) {
        if (this.whitelistSpawnBlocks.isEmpty()) {
            return true;
        }
        for (String block : this.whitelistSpawnBlocks) {
            if (!block.equalsIgnoreCase(b.getType().toString())) continue;
            return true;
        }
        return false;
    }

    public boolean hasBlacklistBlock(Block b) {
        if (this.blacklistSpawnBlocks.isEmpty()) {
            return false;
        }
        for (String block : this.blacklistSpawnBlocks) {
            if (!block.equalsIgnoreCase(b.getType().toString())) continue;
            return true;
        }
        return false;
    }

    public BlockLevelLimit getBlockLevelLimit() {
        return this.blockLevelLimit;
    }

    public Map<Material, Material> getBlockReplacement() {
        return this.blockReplacement;
    }

    public double getReplacementBlocksDelay() {
        return this.replacementBlocksDelay;
    }

    public void setReplacementBlocksDelay(double value) {
        this.replacementBlocksDelay = value;
    }

    public int getWorldHeightRestriction() {
        return this.worldHeightRestriction;
    }

    public void setWorldHeightRestriction(int structureHeight) {
        this.worldHeightRestriction = Math.max(-1, structureHeight);
    }
}

