/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties;

import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class MaskProperty {
    private final List<Mask> masks;
    private MaskUnion unionType;

    public MaskProperty(String name, FileConfiguration configuration) {
        this.masks = new ArrayList<Mask>();
        if (!configuration.contains(name)) {
            return;
        }
        ConfigurationSection cs = configuration.getConfigurationSection(name);
        assert (cs != null);
        if (!cs.contains("Enabled") || !cs.getBoolean("Enabled")) {
            return;
        }
        this.unionType = cs.contains("UnionType") ? MaskUnion.valueOf(Objects.requireNonNull(cs.getString("UnionType")).toUpperCase()) : MaskUnion.AND;
        this.processBlockTypeMask(cs);
        this.processNegateBlockTypeMask(cs);
    }

    public MaskProperty(List<Mask> masks, MaskUnion unionType) {
        this.masks = masks;
        this.unionType = unionType;
    }

    public MaskUnion getUnionType() {
        return this.unionType;
    }

    public void setUnionType(MaskUnion type) {
        this.unionType = type;
    }

    public void addMask(Mask mask) {
        this.masks.add(mask);
    }

    public List<Mask> getMasks() {
        return this.masks;
    }

    public List<Mask> getMasks(Extent extent) {
        ArrayList<Mask> output = new ArrayList<Mask>(this.getMasks());
        for (Mask mask : output) {
            ((AbstractExtentMask)mask).setExtent(extent);
        }
        return output;
    }

    private void processBlockTypeMask(ConfigurationSection cs) {
        if (!cs.contains("BlockTypeMask")) {
            return;
        }
        ArrayList<BlockType> blockTypes = new ArrayList<BlockType>();
        List blockTypeStrings = cs.getStringList("BlockTypeMask");
        for (String s : blockTypeStrings) {
            blockTypes.add((BlockType)BlockType.REGISTRY.get(s.toLowerCase()));
        }
        BlockTypeMask blockTypeMask = new BlockTypeMask((Extent)new NullExtent(), blockTypes);
        this.addMask((Mask)blockTypeMask);
    }

    private void processNegateBlockTypeMask(ConfigurationSection cs) {
        if (!cs.contains("NegatedBlockMask")) {
            return;
        }
        ArrayList blockTypes = new ArrayList(BlockType.REGISTRY.values());
        List blockTypeStrings = cs.getStringList("NegatedBlockMask");
        for (String s : blockTypeStrings) {
            blockTypes.remove(BlockType.REGISTRY.get(s.toLowerCase()));
        }
        BlockTypeMask blockTypeMask = new BlockTypeMask((Extent)new NullExtent(), blockTypes);
        this.addMask((Mask)blockTypeMask);
    }

    public static enum MaskUnion {
        AND,
        OR;

    }
}

