/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties;

import com.ryandw11.structure.exceptions.StructureConfigurationException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottomSpaceFill {
    private final Map<Biome, Material> blockMap;
    private Material defaultMaterial;
    private boolean enabled = false;

    public BottomSpaceFill(FileConfiguration configuration) {
        this.blockMap = new HashMap<Biome, Material>();
        if (!configuration.contains("BottomSpaceFill")) {
            return;
        }
        ConfigurationSection fillSection = Objects.requireNonNull(configuration.getConfigurationSection("BottomSpaceFill"));
        this.enabled = true;
        for (String keyGroup : fillSection.getKeys(false)) {
            Material fillMaterial;
            String[] keys = keyGroup.split(",");
            try {
                fillMaterial = Material.valueOf((String)Objects.requireNonNull(fillSection.getString(keyGroup)).toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                throw new StructureConfigurationException("Unknown fill material " + fillSection.getString(keyGroup) + " in BottomSpaceFill configuration section.");
            }
            for (String key : keys) {
                Biome biome;
                if (key.equalsIgnoreCase("default")) {
                    this.defaultMaterial = fillMaterial;
                    continue;
                }
                try {
                    biome = Biome.valueOf((String)key.toUpperCase());
                }
                catch (IllegalArgumentException ex) {
                    throw new StructureConfigurationException("Unknown biome " + key + " in BottomSpaceFill configuration section.");
                }
                this.blockMap.put(biome, fillMaterial);
            }
        }
    }

    public BottomSpaceFill() {
        this.enabled = false;
        this.blockMap = new HashMap<Biome, Material>();
    }

    public BottomSpaceFill(@Nullable Material defaultMaterial, @NotNull Map<Biome, Material> blockFillMap) {
        this.enabled = true;
        this.defaultMaterial = defaultMaterial;
        this.blockMap = Objects.requireNonNull(blockFillMap);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setDefaultFillMaterial(@Nullable Material material) {
        this.defaultMaterial = material;
    }

    public Optional<Material> getDefaultFillMaterial() {
        return Optional.ofNullable(this.defaultMaterial);
    }

    @NotNull
    public Map<Biome, Material> getFillBlockMap() {
        return this.blockMap;
    }

    public Optional<Material> getFillMaterial(Biome biome) {
        if (this.blockMap.containsKey(biome)) {
            return Optional.of(this.blockMap.get(biome));
        }
        return Optional.ofNullable(this.defaultMaterial);
    }
}

