/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure.properties;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.structure.properties.schematics.SubSchematic;
import com.ryandw11.structure.utils.RandomCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

public class AdvancedSubSchematics {
    private boolean enabled;
    private final Map<String, RandomCollection<SubSchematic>> schematicCategories;

    public AdvancedSubSchematics(@NotNull FileConfiguration configuration, @NotNull CustomStructures plugin) {
        this.schematicCategories = new HashMap<String, RandomCollection<SubSchematic>>();
        if (!configuration.contains("AdvancedSubSchematics")) {
            this.enabled = false;
            return;
        }
        ConfigurationSection section = configuration.getConfigurationSection("AdvancedSubSchematics");
        assert (section != null);
        for (String category : section.getKeys(false)) {
            RandomCollection<SubSchematic> schematics;
            block6: {
                schematics = new RandomCollection<SubSchematic>();
                try {
                    for (String schemName : Objects.requireNonNull(section.getConfigurationSection(category)).getKeys(false)) {
                        SubSchematic schem = new SubSchematic(Objects.requireNonNull(section.getConfigurationSection(String.format("%s.%s", category, schemName))), true);
                        schematics.add(schem.getWeight(), schem);
                    }
                }
                catch (RuntimeException ex) {
                    this.enabled = false;
                    plugin.getLogger().warning("Unable to enable AdvancedSubStructures on structure " + configuration.getName() + ".");
                    plugin.getLogger().warning("The following error occurred:");
                    plugin.getLogger().warning(ex.getMessage());
                    if (!plugin.isDebug()) break block6;
                    ex.printStackTrace();
                }
            }
            this.schematicCategories.put(category, schematics);
        }
        this.enabled = true;
    }

    public AdvancedSubSchematics(boolean enabled) {
        this.enabled = enabled;
        this.schematicCategories = new HashMap<String, RandomCollection<SubSchematic>>();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Map<String, RandomCollection<SubSchematic>> getSchematicCategories() {
        return this.schematicCategories;
    }

    public RandomCollection<SubSchematic> getCategory(String name) {
        return this.schematicCategories.get(name);
    }

    public boolean containsCategory(String name) {
        return this.schematicCategories.containsKey(name);
    }

    public List<String> getCategoryNames() {
        return new ArrayList<String>(this.schematicCategories.keySet());
    }

    public void addCategory(String name, RandomCollection<SubSchematic> schematics) {
        this.schematicCategories.put(name, schematics);
    }

    public void addSchematicToCategory(String categoryName, SubSchematic subSchematic) {
        if (!this.schematicCategories.containsKey(categoryName)) {
            throw new IllegalArgumentException("Category does not exist.");
        }
        if (subSchematic.getWeight() == 0.0) {
            throw new IllegalArgumentException("Sub-Schematic weight cannot be zero.");
        }
        this.schematicCategories.get(categoryName).add(subSchematic.getWeight(), subSchematic);
    }
}

