/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.exceptions.StructureConfigurationException;
import com.ryandw11.structure.io.StructureDatabaseHandler;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.structure.StructureBuilder;
import com.ryandw11.structure.threading.CheckStructureList;
import com.ryandw11.structure.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class StructureHandler {
    private final SortedMap<Pair<Location, Long>, Structure> spawnedStructures = new TreeMap<Pair, Structure>(Comparator.comparingDouble(o -> ((Location)o.getLeft()).distance(new Location(((Location)o.getLeft()).getWorld(), 0.0, 0.0, 0.0))));
    private final List<Structure> structures = new ArrayList<Structure>();
    private final List<String> names = new ArrayList<String>();
    private final CheckStructureList checkStructureList;
    private StructureDatabaseHandler structureDatabaseHandler;

    public StructureHandler(List<String> stringStructs, CustomStructures cs) {
        cs.getLogger().info("Loading structures from files.");
        for (String s : stringStructs) {
            File struct = new File(cs.getDataFolder() + File.separator + "structures" + File.separator + s.replace(".yml", "") + ".yml");
            if (!struct.exists()) {
                cs.getLogger().warning("Structure file: " + s + ".yml does not exist! Did you make a new structure file in the Structure folder?");
                cs.getLogger().warning("For more information please check to wiki.");
                continue;
            }
            try {
                Structure tempStruct = new StructureBuilder(s.replace(".yml", ""), struct).build();
                this.structures.add(tempStruct);
                this.names.add(tempStruct.getName());
            }
            catch (StructureConfigurationException ex) {
                cs.getLogger().warning("The structure '" + s + "' has an invalid configuration file:");
                cs.getLogger().warning(ex.getMessage());
            }
            catch (Exception ex) {
                cs.getLogger().severe("An unexpected error has occurred when trying to load the structure: " + s + ".");
                cs.getLogger().severe("Please ensure that your configuration file is valid!");
                if (cs.isDebug()) {
                    ex.printStackTrace();
                    continue;
                }
                cs.getLogger().severe("Please enable debug mode to see the full error.");
            }
        }
        this.checkStructureList = new CheckStructureList(this);
        this.checkStructureList.runTaskTimerAsynchronously((Plugin)cs, 20L, 6000L);
        if (cs.getConfig().getBoolean("logStructures")) {
            this.structureDatabaseHandler = new StructureDatabaseHandler(cs);
            this.structureDatabaseHandler.runTaskTimerAsynchronously((Plugin)cs, 20L, 300L);
        }
    }

    public List<Structure> getStructures() {
        return Collections.unmodifiableList(this.structures);
    }

    public Structure getStructure(String name) {
        List result = this.structures.stream().filter(struct -> struct.getName().equals(name)).collect(Collectors.toList());
        if (result.isEmpty()) {
            return null;
        }
        return (Structure)result.get(0);
    }

    public Structure getStructure(int i) {
        return this.structures.get(i);
    }

    public List<String> getStructureNames() {
        return this.names;
    }

    public SortedMap<Pair<Location, Long>, Structure> getSpawnedStructures() {
        return this.spawnedStructures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSpawnedStructure(Location loc, Structure struct) {
        SortedMap<Pair<Location, Long>, Structure> sortedMap = this.spawnedStructures;
        synchronized (sortedMap) {
            if (this.structureDatabaseHandler != null) {
                this.structureDatabaseHandler.addStructure(loc, struct);
            }
            this.spawnedStructures.put(Pair.of(loc, System.currentTimeMillis()), struct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validDistance(Structure struct, Location location) {
        double closest = Double.MAX_VALUE;
        SortedMap<Pair<Location, Long>, Structure> sortedMap = this.spawnedStructures;
        synchronized (sortedMap) {
            for (Map.Entry<Pair<Location, Long>, Structure> entry : this.spawnedStructures.entrySet()) {
                if (entry.getKey().getLeft().getWorld() != location.getWorld() || !(entry.getKey().getLeft().distance(location) < closest)) continue;
                closest = entry.getKey().getLeft().distance(location);
            }
        }
        return struct.getStructureLocation().getDistanceFromOthers() < closest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validSameDistance(Structure struct, Location location) {
        SortedMap<Pair<Location, Long>, Structure> sortedMap = this.spawnedStructures;
        synchronized (sortedMap) {
            double closest = Double.MAX_VALUE;
            for (Map.Entry<Pair<Location, Long>, Structure> entry : this.spawnedStructures.entrySet()) {
                if (entry.getKey().getLeft().getWorld() != location.getWorld() || !Objects.equals(entry.getValue().getName(), struct.getName()) || !(entry.getKey().getLeft().distance(location) < closest)) continue;
                closest = entry.getKey().getLeft().distance(location);
            }
            return struct.getStructureLocation().getDistanceFromSame() < closest;
        }
    }

    public Optional<StructureDatabaseHandler> getStructureDatabaseHandler() {
        return Optional.ofNullable(this.structureDatabaseHandler);
    }

    public void cleanup() {
        this.checkStructureList.cancel();
        if (this.structureDatabaseHandler != null) {
            this.structureDatabaseHandler.cancel();
        }
        this.spawnedStructures.clear();
    }
}

