/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.structure;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.api.structaddon.CustomStructureAddon;
import com.ryandw11.structure.api.structaddon.StructureSection;
import com.ryandw11.structure.api.structaddon.StructureSectionProvider;
import com.ryandw11.structure.exceptions.StructureConfigurationException;
import com.ryandw11.structure.loottables.LootTable;
import com.ryandw11.structure.loottables.LootTableType;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.structure.properties.AdvancedSubSchematics;
import com.ryandw11.structure.structure.properties.BottomSpaceFill;
import com.ryandw11.structure.structure.properties.MaskProperty;
import com.ryandw11.structure.structure.properties.StructureLimitations;
import com.ryandw11.structure.structure.properties.StructureLocation;
import com.ryandw11.structure.structure.properties.StructureProperties;
import com.ryandw11.structure.structure.properties.SubSchematics;
import com.ryandw11.structure.utils.RandomCollection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class StructureBuilder {
    private FileConfiguration config;
    private final CustomStructures plugin;
    protected String name;
    protected String schematic;
    protected int probabilityNumerator;
    protected int probabilityDenominator;
    protected int priority;
    protected String compiledSchematic;
    protected boolean isCompiled = false;
    protected StructureLocation structureLocation;
    protected StructureProperties structureProperties;
    protected StructureLimitations structureLimitations;
    protected MaskProperty sourceMaskProperty;
    protected MaskProperty targetMaskProperty;
    protected SubSchematics subSchematics;
    protected AdvancedSubSchematics advancedSubSchematics;
    protected BottomSpaceFill bottomSpaceFill;
    protected Map<LootTableType, RandomCollection<LootTable>> lootTables;
    protected List<StructureSection> structureSections;
    protected double baseRotation;

    public StructureBuilder(String name, String schematic) {
        this(name, schematic, new ArrayList<StructureSection>());
    }

    public StructureBuilder(String name, String schematic, List<StructureSection> sections) {
        this.plugin = CustomStructures.getInstance();
        this.name = name;
        this.schematic = schematic;
        this.priority = 100;
        this.baseRotation = 0.0;
        this.lootTables = new HashMap<LootTableType, RandomCollection<LootTable>>();
        this.structureSections = sections;
    }

    public StructureBuilder(String name, String schematic, StructureSection ... sections) {
        this.plugin = CustomStructures.getInstance();
        this.name = name;
        this.schematic = schematic;
        this.priority = 100;
        this.baseRotation = 0.0;
        this.lootTables = new HashMap<LootTableType, RandomCollection<LootTable>>();
        this.structureSections = Arrays.asList(sections);
    }

    public StructureBuilder(String name, File file) {
        if (!file.exists()) {
            throw new RuntimeException("Cannot build structure: That file does not exist!");
        }
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.plugin = CustomStructures.getInstance();
        this.name = name;
        this.structureSections = new ArrayList<StructureSection>();
        this.checkValidity();
        this.schematic = this.config.getString("Schematic");
        this.probabilityNumerator = this.config.getInt("Probability.Numerator");
        this.probabilityDenominator = this.config.getInt("Probability.Denominator");
        this.priority = this.config.contains("Priority") ? this.config.getInt("Priority") : 100;
        this.baseRotation = 0.0;
        if (this.config.contains("CompiledSchematic")) {
            this.isCompiled = new File(CustomStructures.getInstance().getDataFolder() + "/schematics/" + Objects.requireNonNull(this.config.getString("CompiledSchematic"))).exists();
            if (!this.isCompiled) {
                CustomStructures.getInstance().getLogger().severe("Invalid compiled schematic file for: " + name);
            } else {
                this.compiledSchematic = this.config.getString("CompiledSchematic");
            }
        }
        this.structureLocation = new StructureLocation(this.config);
        this.structureProperties = new StructureProperties(this.config);
        this.structureLimitations = new StructureLimitations(this.config);
        this.sourceMaskProperty = new MaskProperty("SourceMask", this.config);
        this.targetMaskProperty = new MaskProperty("TargetMask", this.config);
        this.subSchematics = new SubSchematics(this.config, CustomStructures.getInstance());
        this.advancedSubSchematics = new AdvancedSubSchematics(this.config, CustomStructures.getInstance());
        this.bottomSpaceFill = new BottomSpaceFill(this.config);
        this.lootTables = new HashMap<LootTableType, RandomCollection<LootTable>>();
        if (this.config.contains("LootTables")) {
            ConfigurationSection lootableConfig = this.config.getConfigurationSection("LootTables");
            assert (lootableConfig != null);
            for (String lootTable : lootableConfig.getKeys(false)) {
                if (!LootTableType.exists(lootTable)) continue;
                LootTableType lootTableType = LootTableType.valueOf(lootTable.toUpperCase());
                for (String lootTableName : Objects.requireNonNull(lootableConfig.getConfigurationSection(lootTable)).getKeys(false)) {
                    int weight = lootableConfig.getInt(lootTable + "." + lootTableName);
                    LootTable table = CustomStructures.getInstance().getLootTableHandler().getLootTableByName(lootTableName);
                    table.addType(lootTableType);
                    if (this.lootTables.containsKey((Object)lootTableType)) {
                        this.lootTables.get((Object)lootTableType).add(weight, table);
                        continue;
                    }
                    this.lootTables.put(lootTableType, new RandomCollection());
                    this.lootTables.get((Object)lootTableType).add(weight, table);
                }
            }
        }
        for (CustomStructureAddon addon : CustomStructures.getInstance().getAddonHandler().getCustomStructureAddons()) {
            for (StructureSectionProvider structureSectionProvider : addon.getProviderSet()) {
                try {
                    StructureSection section = structureSectionProvider.createSection();
                    if (!this.config.contains(section.getName())) {
                        section.setupSection(null);
                    } else {
                        section.setupSection(this.config.getConfigurationSection(section.getName()));
                    }
                    this.structureSections.add(section);
                }
                catch (StructureConfigurationException ex) {
                    throw new StructureConfigurationException(String.format("[%s Addon] %s. This is notan issue with the CustomStructures plugin.", addon.getName(), ex.getMessage()));
                }
                catch (Throwable ex) {
                    this.plugin.getLogger().severe(String.format("An error was encountered in the %s addon! Enable debug for more information.", addon.getName()));
                    this.plugin.getLogger().severe(ex.getMessage());
                    this.plugin.getLogger().severe("This is not an issue with CustomStructures! Please contact the addon developer.");
                    if (!this.plugin.isDebug()) continue;
                    ex.printStackTrace();
                }
            }
            for (Class clazz : addon.getStructureSections()) {
                try {
                    StructureSection constructedSection = (StructureSection)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!this.config.contains(constructedSection.getName())) {
                        constructedSection.setupSection(null);
                    } else {
                        constructedSection.setupSection(this.config.getConfigurationSection(constructedSection.getName()));
                    }
                    this.structureSections.add(constructedSection);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    this.plugin.getLogger().severe(String.format("The section %s for the addon %sis configured incorrectly. If you are the developer please refer to the API documentation.", clazz.getName(), addon.getName()));
                    this.plugin.getLogger().severe("This is not an issue with CustomStructures.Report this error to the addon developer!!");
                }
                catch (StructureConfigurationException ex) {
                    throw new StructureConfigurationException(String.format("[%s Addon] %s. This is notan issue with the CustomStructures plugin.", addon.getName(), ex.getMessage()));
                }
                catch (Exception ex) {
                    this.plugin.getLogger().severe(String.format("An error was encountered in the %s addon! Enable debug for more information.", addon.getName()));
                    this.plugin.getLogger().severe(ex.getMessage());
                    this.plugin.getLogger().severe("This is not an issue with CustomStructures! Please contact the addon developer.");
                    if (!this.plugin.isDebug()) continue;
                    ex.printStackTrace();
                }
            }
        }
    }

    private void checkValidity() {
        if (!this.config.contains("Schematic")) {
            throw new StructureConfigurationException("Invalid structure config: No Schematic found!");
        }
        if (!this.config.contains("Probability.Numerator")) {
            throw new StructureConfigurationException("Invalid structure config: `Probability.Numerator` is required!");
        }
        if (!this.config.contains("Probability.Denominator")) {
            throw new StructureConfigurationException("Invalid structure config: `Probability.Denominator` is required!");
        }
        if (!this.config.isInt("Probability.Numerator") || this.config.getInt("Probability.Numerator") < 1) {
            throw new StructureConfigurationException("Invalid structure config: `Probability.Numerator` must be a number cannot be less than 1!");
        }
        if (!this.config.isInt("Probability.Denominator") || this.config.getInt("Probability.Denominator") < 1) {
            throw new StructureConfigurationException("Invalid structure config: `Probability.Denominator` must be a number cannot be less than 1!");
        }
    }

    public void setProbability(int numerator, int denominator) {
        this.probabilityNumerator = numerator;
        this.probabilityDenominator = denominator;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setCompiledSchematic(String cschem) {
        if (!new File(CustomStructures.getInstance().getDataFolder() + "/schematics/" + cschem).exists()) {
            throw new IllegalArgumentException("Compiled Schem File not found!");
        }
        this.compiledSchematic = cschem;
        this.isCompiled = true;
    }

    public void setStructureLimitations(StructureLimitations limitations) {
        this.structureLimitations = limitations;
    }

    public void setStructureProperties(StructureProperties properties) {
        this.structureProperties = properties;
    }

    public void setStructureLocation(StructureLocation location) {
        this.structureLocation = location;
    }

    public void setSourceMaskProperty(MaskProperty mask) {
        this.sourceMaskProperty = mask;
    }

    public void setTargetMaskProperty(MaskProperty mask) {
        this.targetMaskProperty = mask;
    }

    public void setBottomSpaceFill(BottomSpaceFill bottomSpaceFill) {
        this.bottomSpaceFill = bottomSpaceFill;
    }

    public void setSubSchematics(SubSchematics subSchematics) {
        this.subSchematics = subSchematics;
    }

    public void setAdvancedSubSchematics(AdvancedSubSchematics advancedSubSchematics) {
        this.advancedSubSchematics = advancedSubSchematics;
    }

    public void setLootTables(ConfigurationSection lootableConfig) {
        this.lootTables = new HashMap<LootTableType, RandomCollection<LootTable>>();
        assert (lootableConfig != null);
        for (String lootTable : lootableConfig.getKeys(false)) {
            if (!LootTableType.exists(lootTable)) continue;
            LootTableType type = LootTableType.valueOf(lootTable.toUpperCase());
            for (String lootTableName : Objects.requireNonNull(lootableConfig.getConfigurationSection(lootTable)).getKeys(false)) {
                int weight = lootableConfig.getInt(lootTable + "." + lootTableName);
                LootTable table = CustomStructures.getInstance().getLootTableHandler().getLootTableByName(lootTableName);
                table.addType(type);
                if (this.lootTables.containsKey((Object)type)) {
                    this.lootTables.get((Object)type).add(weight, table);
                    continue;
                }
                this.lootTables.put(type, new RandomCollection());
                this.lootTables.get((Object)type).add(weight, table);
            }
        }
    }

    public void setLootTables(Map<LootTableType, RandomCollection<LootTable>> lootTables) {
        this.lootTables = lootTables;
    }

    public void addLootTable(LootTable lootTable, double weight) {
        for (LootTableType type : lootTable.getTypes()) {
            if (!this.lootTables.containsKey((Object)type)) {
                this.lootTables.put(type, new RandomCollection());
            }
            this.lootTables.get((Object)type).add(weight, lootTable);
        }
    }

    public void setBaseRotation(double baseRotation) {
        this.baseRotation = baseRotation;
    }

    public void addStructureSection(StructureSection structureSection) {
        this.structureSections.add(structureSection);
    }

    public Structure build() {
        Objects.requireNonNull(this.name, "The structure name cannot be null.");
        Objects.requireNonNull(this.schematic, "The structure schematic cannot be null.");
        Objects.requireNonNull(this.structureLocation, "The structure location cannot be null.");
        Objects.requireNonNull(this.structureProperties, "The structure property cannot be null.");
        Objects.requireNonNull(this.structureLimitations, "The structure limitations cannot be null.");
        Objects.requireNonNull(this.sourceMaskProperty, "The structure source mask property cannot be null.");
        Objects.requireNonNull(this.targetMaskProperty, "The structure target mask property cannot be null.");
        Objects.requireNonNull(this.subSchematics, "The structure sub-schematic property cannot be null.");
        Objects.requireNonNull(this.advancedSubSchematics, "The structure advanced sub-schematic property cannot be null.");
        Objects.requireNonNull(this.bottomSpaceFill, "The structure bottom space fill property cannot be null.");
        Objects.requireNonNull(this.lootTables, "The structure loot tables cannot be null.");
        Objects.requireNonNull(this.structureSections, "The structure sections list cannot be null.");
        return new Structure(this);
    }

    public void save(File file) throws IOException {
        file.createNewFile();
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.config.set("Schematic", (Object)this.schematic);
        this.config.set("Probability.Numerator", (Object)this.probabilityNumerator);
        this.config.set("Probability.Denominator", (Object)this.probabilityDenominator);
        this.config.set("StructureLocation.Worlds", this.structureLocation.getWorlds());
        this.config.set("StructureLocation.SpawnY", (Object)this.structureLocation.getSpawnSettings().getValue());
        this.config.set("StructureLocation.SpawnYHeightMap", (Object)this.structureLocation.getSpawnSettings().getHeightMap().toString());
        this.config.set("StructureLocation.Biome", this.structureLocation.getBiomes());
        this.config.set("StructureProperties.PlaceAir", (Object)this.structureProperties.canPlaceAir());
        this.config.set("StructureProperties.RandomRotation", (Object)this.structureProperties.isRandomRotation());
        this.config.set("StructureProperties.IgnorePlants", (Object)this.structureProperties.isIgnoringPlants());
        this.config.set("StructureProperties.SpawnInWater", (Object)this.structureProperties.canSpawnInWater());
        this.config.set("StructureProperties.SpawnInLavaLakes", (Object)this.structureProperties.canSpawnInLavaLakes());
        this.config.set("StructureLimitations.WhitelistSpawnBlocks", this.structureLimitations.getWhitelistBlocks());
        if (this.isCompiled) {
            this.config.set("CompiledSchematic", (Object)this.compiledSchematic);
        }
        for (Map.Entry<LootTableType, RandomCollection<LootTable>> loot : this.lootTables.entrySet()) {
            for (Map.Entry<Double, LootTable> entry : loot.getValue().getMap().entrySet()) {
                this.config.set("LootTables." + loot.getKey().toString() + "." + entry.getValue().getName(), (Object)entry.getKey());
            }
        }
        this.config.save(file);
    }
}

