/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.schematic;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.api.structaddon.StructureSign;
import com.ryandw11.structure.schematic.SchematicHandler;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.structure.properties.AdvancedSubSchematics;
import com.ryandw11.structure.structure.properties.SubSchematics;
import com.ryandw11.structure.structure.properties.schematics.SubSchematic;
import com.ryandw11.structure.structure.properties.schematics.VerticalRepositioning;
import com.ryandw11.structure.utils.CSUtils;
import com.ryandw11.structure.utils.NumberStylizer;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;

public class SchematicSignReplacer {
    private SchematicSignReplacer() {
    }

    protected static void processAndReplaceSign(Location location, Location minLoc, Location maxLoc, Structure structure, double structureRotation) {
        double signRotation;
        CustomStructures plugin = CustomStructures.getInstance();
        if (!(location.getBlock().getState() instanceof Sign) && !(location.getBlock().getState() instanceof WallSign)) {
            return;
        }
        Sign sign = (Sign)location.getBlock().getState();
        String firstLine = sign.getLine(0).trim();
        String secondLine = sign.getLine(1).trim();
        String thirdLine = sign.getLine(2).trim();
        String fourthLine = sign.getLine(3).trim();
        if (!firstLine.startsWith("[")) {
            return;
        }
        String signName = firstLine.replaceAll("\\[", "").replaceAll("]", "");
        if (!plugin.getStructureSignHandler().structureSignExists(signName)) {
            return;
        }
        BlockData blockData = location.getBlock().getBlockData();
        if (blockData instanceof org.bukkit.block.data.type.Sign) {
            org.bukkit.block.data.type.Sign signData = (org.bukkit.block.data.type.Sign)blockData;
            direction = signData.getRotation().getDirection();
            signRotation = Math.atan2(direction.getZ(), direction.getX());
            signRotation = direction.getX() != 0.0 ? (signRotation -= 1.5707963267948966) : (signRotation += 1.5707963267948966);
        } else {
            direction = location.getBlock().getBlockData();
            if (direction instanceof WallSign) {
                WallSign signData = (WallSign)direction;
                direction = signData.getFacing().getDirection();
                signRotation = Math.atan2(direction.getZ(), direction.getX());
                signRotation = direction.getX() != 0.0 ? (signRotation -= 1.5707963267948966) : (signRotation += 1.5707963267948966);
            } else {
                signRotation = 0.0;
            }
        }
        Class<? extends StructureSign> structureSignClass = plugin.getStructureSignHandler().getStructureSign(signName);
        try {
            StructureSign structureSign = structureSignClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            String[] args = new String[]{secondLine, thirdLine, fourthLine};
            structureSign.initialize(args, signRotation, structureRotation, minLoc, maxLoc);
            if (structureSign.onStructureSpawn(location, structure)) {
                location.getBlock().setType(Material.AIR);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
            plugin.getLogger().severe(String.format("Unable to process structure sign %s in structure %s!", signName, structure.getName()));
            plugin.getLogger().severe("Does that structure sign class have a default constructor?");
        }
    }

    protected static void replaceSignWithSchematic(Location location, Structure parentStructure, int iteration) {
        block29: {
            CustomStructures plugin = CustomStructures.getInstance();
            SubSchematics subSchematics = parentStructure.getSubSchematics();
            AdvancedSubSchematics advancedSubSchematics = parentStructure.getAdvancedSubSchematics();
            Sign sign = (Sign)location.getBlock().getState();
            String firstLine = sign.getLine(0).trim();
            String secondLine = sign.getLine(1).trim();
            BlockData blockData = location.getBlock().getBlockData();
            if (blockData instanceof org.bukkit.block.data.type.Sign) {
                org.bukkit.block.data.type.Sign signData = (org.bukkit.block.data.type.Sign)blockData;
                direction = signData.getRotation().getDirection();
                rotation = Math.atan2(direction.getZ(), direction.getX());
                rotation = direction.getX() != 0.0 ? (rotation -= 1.5707963267948966) : (rotation += 1.5707963267948966);
                parentStructure.setSubSchemRotation(rotation);
            } else {
                direction = location.getBlock().getBlockData();
                if (direction instanceof WallSign) {
                    WallSign signData = (WallSign)direction;
                    direction = signData.getFacing().getDirection();
                    rotation = Math.atan2(direction.getZ(), direction.getX());
                    rotation = direction.getX() != 0.0 ? (rotation -= 1.5707963267948966) : (rotation += 1.5707963267948966);
                    parentStructure.setSubSchemRotation(rotation);
                }
            }
            if (firstLine.equalsIgnoreCase("[schematic]") || firstLine.equalsIgnoreCase("[schem]")) {
                int number;
                if (secondLine.startsWith("[")) {
                    try {
                        number = NumberStylizer.retrieveRangedInput(secondLine);
                    }
                    catch (NumberFormatException ex) {
                        plugin.getLogger().warning("Invalid schematic sign on structure. Cannot parse ranged number.");
                        return;
                    }
                }
                try {
                    number = Integer.parseInt(secondLine);
                }
                catch (NumberFormatException ex) {
                    plugin.getLogger().warning("Invalid schematic sign on structure. Cannot parse number.");
                    return;
                }
                if (number < -1 || number >= subSchematics.getSchematics().size()) {
                    plugin.getLogger().warning("Invalid schematic sign on structure. Schematic number is not within the valid bounds.");
                    return;
                }
                location.getBlock().setType(Material.AIR);
                SubSchematic subSchem = subSchematics.getSchematics().get(number);
                if (!subSchem.isUsingRotation()) {
                    parentStructure.setSubSchemRotation(0.0);
                }
                try {
                    if (subSchem.getVerticalRepositioning() != null) {
                        VerticalRepositioning vertRep = subSchem.getVerticalRepositioning();
                        Location heightBlock = location.getWorld().getHighestBlockAt(location, vertRep.getSpawnYHeightMap()).getLocation();
                        int newSpawnY = vertRep.getSpawnY(heightBlock);
                        if (vertRep.getRange() == null || CSUtils.isPairInLocalRange(vertRep.getRange(), location.getBlockY(), newSpawnY)) {
                            location = new Location(location.getWorld(), (double)location.getBlockX(), (double)newSpawnY, (double)location.getBlockZ());
                        } else if (!vertRep.getNoPointSolution().equalsIgnoreCase("CURRENT")) {
                            if (vertRep.getNoPointSolution().equalsIgnoreCase("PREVENT_SPAWN")) {
                                return;
                            }
                            newSpawnY = NumberStylizer.getStylizedSpawnY(vertRep.getNoPointSolution(), location);
                            location = new Location(location.getWorld(), (double)location.getBlockX(), (double)newSpawnY, (double)location.getBlockZ());
                        }
                    }
                    SchematicHandler.placeSchematic(location, subSchem.getFile(), subSchem.isPlacingAir(), parentStructure, iteration + 1);
                }
                catch (Exception ex) {
                    plugin.getLogger().warning("An error has occurred when attempting to paste a sub schematic.");
                    if (plugin.isDebug()) {
                        ex.printStackTrace();
                    }
                    break block29;
                }
            }
            if (firstLine.equalsIgnoreCase("[advschem]")) {
                if (!advancedSubSchematics.containsCategory(secondLine)) {
                    plugin.getLogger().warning("Cannot replace Advanced Sub-Schematic sign.");
                    plugin.getLogger().warning(String.format("The category \"%s\" does not exist!", secondLine));
                    return;
                }
                location.getBlock().setType(Material.AIR);
                SubSchematic subSchem = advancedSubSchematics.getCategory(secondLine).next();
                if (!subSchem.isUsingRotation()) {
                    parentStructure.setSubSchemRotation(0.0);
                }
                try {
                    if (subSchem.getVerticalRepositioning() != null) {
                        VerticalRepositioning vertRep = subSchem.getVerticalRepositioning();
                        Location heightBlock = location.getWorld().getHighestBlockAt(location, vertRep.getSpawnYHeightMap()).getLocation();
                        int newSpawnY = vertRep.getSpawnY(heightBlock);
                        if (vertRep.getRange() == null || CSUtils.isPairInLocalRange(vertRep.getRange(), location.getBlockY(), newSpawnY)) {
                            location = new Location(location.getWorld(), (double)location.getBlockX(), (double)newSpawnY, (double)location.getBlockZ());
                        } else if (!vertRep.getNoPointSolution().equalsIgnoreCase("CURRENT")) {
                            if (vertRep.getNoPointSolution().equalsIgnoreCase("PREVENT_SPAWN")) {
                                return;
                            }
                            newSpawnY = NumberStylizer.getStylizedSpawnY(vertRep.getNoPointSolution(), location);
                            location = new Location(location.getWorld(), (double)location.getBlockX(), (double)newSpawnY, (double)location.getBlockZ());
                        }
                    }
                    SchematicHandler.placeSchematic(location, subSchem.getFile(), subSchem.isPlacingAir(), parentStructure, iteration + 1);
                }
                catch (Exception ex) {
                    plugin.getLogger().warning("An error has occurred when attempting to paste a sub schematic.");
                    if (!plugin.isDebug()) break block29;
                    ex.printStackTrace();
                }
            }
        }
    }
}

