/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.schematic;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.api.StructureSpawnEvent;
import com.ryandw11.structure.api.holder.StructureSpawnHolder;
import com.ryandw11.structure.bottomfill.BottomFillProvider;
import com.ryandw11.structure.io.BlockTag;
import com.ryandw11.structure.schematic.LootTableReplacer;
import com.ryandw11.structure.schematic.SchematicLocationUtils;
import com.ryandw11.structure.schematic.SchematicSignReplacer;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.structure.properties.MaskProperty;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MaskIntersection;
import com.sk89q.worldedit.function.mask.MaskUnion;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import me.ryandw11.ods.ObjectDataStructure;
import me.ryandw11.ods.tags.IntTag;
import me.ryandw11.ods.tags.ListTag;
import me.ryandw11.ods.tags.ObjectTag;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class SchematicHandler {
    private SchematicHandler() {
    }

    public static void placeSchematic(Location loc, String filename, boolean useAir, Structure structure, int iteration) throws IOException, WorldEditException {
        Clipboard clipboard;
        CustomStructures plugin = CustomStructures.getInstance();
        if (iteration > structure.getStructureLimitations().getIterationLimit()) {
            plugin.getLogger().severe("Critical Error: StackOverflow detected. Automatically terminating the spawning of the structure.");
            plugin.getLogger().severe("The structure '" + structure.getName() + "' has spawned too many sub structure via recursion.");
            return;
        }
        File schematicFile = new File(plugin.getDataFolder() + "/schematics/" + filename);
        if (!schematicFile.exists() && iteration == 0) {
            Bukkit.broadcastMessage((String)ChatColor.translateAlternateColorCodes((char)'&', (String)"&b[&aCustomStructures&b] &cA fatal error has occurred! Please check the console for errors."));
            plugin.getLogger().warning("Error: The schematic " + filename + " does not exist!");
            plugin.getLogger().warning("If this is your first time using this plugin you need to put a schematic in the schematic folder.");
            plugin.getLogger().warning("Then add it into the config.");
            plugin.getLogger().warning("If you need help look at the wiki: https://github.com/ryandw11/CustomStructures/wiki or contact Ryandw11 on spigot!");
            plugin.getLogger().warning("The plugin will now disable to prevent damage to the server.");
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            return;
        }
        if (!schematicFile.exists()) {
            plugin.getLogger().warning("Error: The schematic " + filename + " does not exist!");
            throw new RuntimeException("Cannot find schematic file!");
        }
        ClipboardFormat format = ClipboardFormats.findByFile((File)schematicFile);
        if (format == null) {
            plugin.getLogger().warning("Invalid schematic format for schematic " + filename + "!");
            plugin.getLogger().warning("Please create a valid schematic using the in-game commands!");
            return;
        }
        try (ClipboardReader reader = format.getReader((InputStream)new FileInputStream(schematicFile));){
            clipboard = reader.read();
        }
        ClipboardHolder ch = new ClipboardHolder(clipboard);
        AffineTransform transform = new AffineTransform();
        double rotY = Math.toDegrees(structure.getBaseRotation());
        if (structure.getStructureProperties().isRandomRotation() && iteration == 0) {
            rotY = new Random().nextInt(4) * 90;
            transform = transform.rotateY(rotY);
            ch.setTransform(ch.getTransform().combine((Transform)transform));
        } else if (iteration != 0) {
            rotY = Math.toDegrees(structure.getSubSchemRotation());
            transform = transform.rotateY(rotY);
            ch.setTransform(ch.getTransform().combine((Transform)transform));
        }
        try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(BukkitAdapter.adapt((World)Objects.requireNonNull(loc.getWorld())), -1);){
            MaskIntersection sourceMask = null;
            if (structure.getSourceMaskProperties().getUnionType() == MaskProperty.MaskUnion.AND) {
                sourceMask = new MaskIntersection(structure.getSourceMaskProperties().getMasks((Extent)clipboard));
            } else if (structure.getSourceMaskProperties().getUnionType() == MaskProperty.MaskUnion.OR) {
                sourceMask = new MaskUnion(structure.getSourceMaskProperties().getMasks((Extent)clipboard));
            }
            MaskIntersection targetMask = null;
            if (structure.getTargetMaskProperties().getUnionType() == MaskProperty.MaskUnion.AND) {
                targetMask = new MaskIntersection(structure.getTargetMaskProperties().getMasks((Extent)editSession));
            } else if (structure.getSourceMaskProperties().getUnionType() == MaskProperty.MaskUnion.OR) {
                targetMask = new MaskUnion(structure.getTargetMaskProperties().getMasks((Extent)editSession));
            }
            editSession.setMask((Mask)targetMask);
            Operation operation = ch.createPaste((Extent)editSession).to(BlockVector3.at((double)loc.getX(), (double)loc.getY(), (double)loc.getZ())).maskSource((Mask)sourceMask).ignoreAirBlocks(!useAir).build();
            Operations.complete((Operation)operation);
            if (plugin.getConfig().getBoolean("debug")) {
                plugin.getLogger().info(String.format("(%s) Created an instance of %s at %s, %s, %s with rotation %s", loc.getWorld().getName(), filename, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), rotY));
            }
        }
        if (structure.getBottomSpaceFill().isEnabled()) {
            Location minLoc = SchematicLocationUtils.getMinimumLocation(clipboard, loc, rotY);
            Location maxLoc = SchematicLocationUtils.getMaximumLocation(clipboard, loc, rotY);
            int lowX = Math.min(minLoc.getBlockX(), maxLoc.getBlockX());
            int lowY = Math.min(minLoc.getBlockY(), maxLoc.getBlockY());
            int lowZ = Math.min(minLoc.getBlockZ(), maxLoc.getBlockZ());
            int highX = Math.max(minLoc.getBlockX(), maxLoc.getBlockX());
            int highY = Math.max(minLoc.getBlockY(), maxLoc.getBlockY());
            int highZ = Math.max(minLoc.getBlockZ(), maxLoc.getBlockZ());
            BottomFillProvider.provide().performFill(structure, loc, new Location(minLoc.getWorld(), (double)lowX, (double)lowY, (double)lowZ), new Location(minLoc.getWorld(), (double)highX, (double)highY, (double)highZ), transform);
        }
        double finalRotY = rotY;
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            List<Object> containersAndSignsLocations = new ArrayList();
            if (structure.isCompiled()) {
                ObjectDataStructure ods = new ObjectDataStructure(new File(plugin.getDataFolder() + "/schematics/" + structure.getCompiledSchematic()));
                ListTag listTag = (ListTag)ods.get("containers");
                ListTag signs = (ListTag)ods.get("signs");
                Location minimumPoint = SchematicLocationUtils.getMinimumLocation(clipboard, loc, 0.0);
                Location maximumPoint = SchematicLocationUtils.getMaximumLocation(clipboard, loc, 0.0);
                int minX = Math.min(minimumPoint.getBlockX(), maximumPoint.getBlockX());
                int minY = Math.min(minimumPoint.getBlockY(), maximumPoint.getBlockY());
                int minZ = Math.min(minimumPoint.getBlockZ(), maximumPoint.getBlockZ());
                Iterator iterator = listTag.getValue().iterator();
                while (iterator.hasNext()) {
                    ObjectTag con = (ObjectTag)iterator.next();
                    containersAndSignsLocations.add(SchematicLocationUtils.rotateAround(new BlockTag(con).getLocation(loc.getWorld()).add((double)minX, (double)minY, (double)minZ), loc, finalRotY));
                }
                iterator = signs.getValue().iterator();
                while (iterator.hasNext()) {
                    ObjectTag sign = (ObjectTag)iterator.next();
                    containersAndSignsLocations.add(SchematicLocationUtils.rotateAround(new BlockTag(sign).getLocation(loc.getWorld()).add((double)minX, (double)minY, (double)minZ), loc, finalRotY));
                }
            } else {
                containersAndSignsLocations = SchematicHandler.getContainersAndSignsLocations(ch.getClipboard(), loc, finalRotY, structure);
            }
            for (Location location : containersAndSignsLocations) {
                if (location.getBlock().getState() instanceof Container) {
                    LootTableReplacer.replaceContainerContent(structure, location);
                }
                if (location.getBlock().getState() instanceof Sign) {
                    Location minLoc = SchematicLocationUtils.getMinimumLocation(clipboard, loc, finalRotY);
                    Location maxLoc = SchematicLocationUtils.getMaximumLocation(clipboard, loc, finalRotY);
                    SchematicSignReplacer.processAndReplaceSign(location, minLoc, maxLoc, structure, finalRotY);
                }
                if (!(location.getBlock().getState() instanceof Sign)) continue;
                SchematicSignReplacer.replaceSignWithSchematic(location, structure, iteration);
            }
            SchematicHandler.replaceBlocks(clipboard, loc, finalRotY, structure);
            if (iteration < 1) {
                StructureSpawnHolder structureSpawnHolder = new StructureSpawnHolder(SchematicLocationUtils.getMinimumLocation(clipboard, loc, 0.0), SchematicLocationUtils.getMaximumLocation(clipboard, loc, 0.0), containersAndSignsLocations);
                StructureSpawnEvent structureSpawnEvent = new StructureSpawnEvent(structure, loc, finalRotY, structureSpawnHolder);
                Bukkit.getServer().getPluginManager().callEvent((Event)structureSpawnEvent);
            }
        }, Math.round(structure.getStructureLimitations().getReplacementBlocksDelay() * 20.0));
    }

    public static void placeSchematic(Location loc, String filename, boolean useAir, Structure structure) throws IOException, WorldEditException {
        SchematicHandler.placeSchematic(loc, filename, useAir, structure, 0);
    }

    public static boolean createSchematic(String name, Player player, World w, boolean compile) {
        CustomStructures plugin = CustomStructures.getInstance();
        try {
            WorldEditPlugin worldEditPlugin = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
            assert (worldEditPlugin != null);
            Region selection = worldEditPlugin.getSession(player).getSelection(BukkitAdapter.adapt((World)w));
            CuboidRegion region = new CuboidRegion(selection.getWorld(), selection.getMinimumPoint(), selection.getMaximumPoint());
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
            clipboard.setOrigin(BlockVector3.at((double)player.getLocation().getX(), (double)player.getLocation().getY(), (double)player.getLocation().getZ()));
            try (EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(selection.getWorld(), -1);){
                ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard, region.getMinimumPoint());
                Operations.complete((Operation)forwardExtentCopy);
            }
            catch (WorldEditException e) {
                e.printStackTrace();
            }
            File file = new File(plugin.getDataFolder() + File.separator + "schematics" + File.separator + name + ".schem");
            try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(file));){
                writer.write((Clipboard)clipboard);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (compile) {
                SchematicHandler.compileSchem(player.getLocation(), selection, name);
            }
            return true;
        }
        catch (IncompleteRegionException ex) {
            return false;
        }
    }

    public static boolean compileOnly(String name, Player player, World w) {
        try {
            WorldEditPlugin worldEditPlugin = (WorldEditPlugin)Bukkit.getServer().getPluginManager().getPlugin("WorldEdit");
            assert (worldEditPlugin != null);
            Region selection = worldEditPlugin.getSession(player).getSelection(BukkitAdapter.adapt((World)w));
            SchematicHandler.compileSchem(player.getLocation(), selection, name);
            return true;
        }
        catch (IncompleteRegionException ex) {
            return false;
        }
    }

    private static void compileSchem(Location loc, Region reg, String name) {
        CustomStructures plugin = CustomStructures.getInstance();
        IntTag intTag = new IntTag("ver", 1);
        ListTag containers = new ListTag("containers", new ArrayList());
        ListTag signs = new ListTag("signs", new ArrayList());
        ArrayList<Location> locations = new ArrayList<Location>();
        Location minLoc = new Location(loc.getWorld(), (double)reg.getMinimumPoint().getX(), (double)reg.getMinimumPoint().getY(), (double)reg.getMinimumPoint().getZ());
        for (int x = reg.getMinimumPoint().getX(); x <= reg.getMaximumPoint().getX(); ++x) {
            for (int y = reg.getMinimumPoint().getY(); y <= reg.getMaximumPoint().getY(); ++y) {
                for (int z = reg.getMinimumPoint().getZ(); z <= reg.getMaximumPoint().getZ(); ++z) {
                    Location location = new Location(loc.getWorld(), (double)x, (double)y, (double)z);
                    Block block = location.getBlock();
                    BlockState blockState = location.getBlock().getState();
                    if (blockState instanceof Container) {
                        BlockState blockState2 = blockState;
                        if (blockState2 instanceof Chest) {
                            Chest chestBlockState = (Chest)blockState2;
                            InventoryHolder holder = chestBlockState.getInventory().getHolder();
                            InventoryHolder inventoryHolder = holder;
                            if (inventoryHolder instanceof DoubleChest) {
                                DoubleChest doubleChest = (DoubleChest)inventoryHolder;
                                Location leftSideLocation = ((Chest)doubleChest.getLeftSide()).getLocation();
                                Location rightSideLocation = ((Chest)doubleChest.getRightSide()).getLocation();
                                Location roundedLocation = new Location(location.getWorld(), Math.floor(location.getX()), Math.floor(location.getY()), Math.floor(location.getZ()));
                                if (leftSideLocation.distance(roundedLocation) < 1.0) {
                                    if (!SchematicLocationUtils.isNotAlreadyIn(locations, rightSideLocation)) continue;
                                    locations.add(roundedLocation);
                                    containers.addTag(new BlockTag(Material.CHEST, location.subtract(minLoc)));
                                    continue;
                                }
                                if (!(rightSideLocation.distance(roundedLocation) < 1.0) || !SchematicLocationUtils.isNotAlreadyIn(locations, leftSideLocation)) continue;
                                locations.add(roundedLocation);
                                containers.addTag(new BlockTag(Material.CHEST, location.subtract(minLoc)));
                                continue;
                            }
                            if (!(holder instanceof Chest)) continue;
                            locations.add(location);
                            containers.addTag(new BlockTag(Material.CHEST, location.subtract(minLoc)));
                            continue;
                        }
                        locations.add(location);
                        containers.addTag(new BlockTag(block.getType(), location.subtract(minLoc)));
                        continue;
                    }
                    if (!(blockState instanceof Sign)) continue;
                    locations.add(location);
                    signs.addTag(new BlockTag(block.getType(), location.subtract(minLoc)));
                }
            }
        }
        ObjectDataStructure ods = new ObjectDataStructure(new File(plugin.getDataFolder() + File.separator + "schematics" + File.separator + name + ".cschem"));
        ods.save(Arrays.asList(intTag, containers, signs));
        if (plugin.isDebug()) {
            plugin.getLogger().info("Successfully compiled the schematic: " + name);
        }
    }

    private static void replaceBlocks(Clipboard clipboard, Location pasteLocation, double rotation, Structure structure) {
        if (structure.getStructureLimitations().getBlockReplacement().isEmpty()) {
            return;
        }
        Location minLoc = SchematicLocationUtils.getMinimumLocation(clipboard, pasteLocation, rotation);
        Location maxLoc = SchematicLocationUtils.getMaximumLocation(clipboard, pasteLocation, rotation);
        int lowX = Math.min(minLoc.getBlockX(), maxLoc.getBlockX());
        int lowY = Math.min(minLoc.getBlockY(), maxLoc.getBlockY());
        int lowZ = Math.min(minLoc.getBlockZ(), maxLoc.getBlockZ());
        for (int x = 0; x <= Math.abs(minLoc.getBlockX() - maxLoc.getBlockX()); ++x) {
            for (int y = 0; y <= Math.abs(minLoc.getBlockY() - maxLoc.getBlockY()); ++y) {
                for (int z = 0; z <= Math.abs(minLoc.getBlockZ() - maxLoc.getBlockZ()); ++z) {
                    Block block = Objects.requireNonNull(pasteLocation.getWorld()).getBlockAt(lowX + x, lowY + y, lowZ + z);
                    if (!structure.getStructureLimitations().getBlockReplacement().containsKey(block.getType())) continue;
                    block.setType(structure.getStructureLimitations().getBlockReplacement().get(block.getType()));
                    block.getState().update();
                }
            }
        }
    }

    private static List<Location> getContainersAndSignsLocations(Clipboard clipboard, Location pasteLocation, double rotation, Structure structure) {
        Location minLoc = SchematicLocationUtils.getMinimumLocation(clipboard, pasteLocation, rotation);
        Location maxLoc = SchematicLocationUtils.getMaximumLocation(clipboard, pasteLocation, rotation);
        ArrayList<Location> locations = new ArrayList<Location>();
        int lowX = Math.min(minLoc.getBlockX(), maxLoc.getBlockX());
        int lowY = Math.min(minLoc.getBlockY(), maxLoc.getBlockY());
        int lowZ = Math.min(minLoc.getBlockZ(), maxLoc.getBlockZ());
        for (int x = 0; x <= Math.abs(minLoc.getBlockX() - maxLoc.getBlockX()); ++x) {
            for (int y = 0; y <= Math.abs(minLoc.getBlockY() - maxLoc.getBlockY()); ++y) {
                for (int z = 0; z <= Math.abs(minLoc.getBlockZ() - maxLoc.getBlockZ()); ++z) {
                    Location location = new Location(pasteLocation.getWorld(), (double)(lowX + x), (double)(lowY + y), (double)(lowZ + z));
                    Block block = location.getBlock();
                    BlockState blockState = location.getBlock().getState();
                    if (blockState instanceof Container) {
                        if (blockState instanceof Chest) {
                            InventoryHolder holder = ((Chest)blockState).getInventory().getHolder();
                            InventoryHolder inventoryHolder = holder;
                            if (inventoryHolder instanceof DoubleChest) {
                                DoubleChest doubleChest = (DoubleChest)inventoryHolder;
                                Location leftSideLocation = ((Chest)doubleChest.getLeftSide()).getLocation();
                                Location rightSideLocation = ((Chest)doubleChest.getRightSide()).getLocation();
                                Location roundedLocation = new Location(location.getWorld(), Math.floor(location.getX()), Math.floor(location.getY()), Math.floor(location.getZ()));
                                if (leftSideLocation.distance(roundedLocation) < 1.0) {
                                    if (!SchematicLocationUtils.isNotAlreadyIn(locations, rightSideLocation)) continue;
                                    locations.add(roundedLocation);
                                    continue;
                                }
                                if (!(rightSideLocation.distance(roundedLocation) < 1.0) || !SchematicLocationUtils.isNotAlreadyIn(locations, leftSideLocation)) continue;
                                locations.add(roundedLocation);
                                continue;
                            }
                            if (!(holder instanceof Chest)) continue;
                            locations.add(location);
                            continue;
                        }
                        locations.add(location);
                        continue;
                    }
                    if (blockState instanceof Sign) {
                        locations.add(location);
                        continue;
                    }
                    if (structure.getStructureLimitations().getBlockReplacement().isEmpty() || !structure.getStructureLimitations().getBlockReplacement().containsKey(block.getType())) continue;
                    block.setType(structure.getStructureLimitations().getBlockReplacement().get(block.getType()));
                    block.getState().update();
                }
            }
        }
        return locations;
    }
}

