/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.schematic;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.api.LootPopulateEvent;
import com.ryandw11.structure.loottables.LootTable;
import com.ryandw11.structure.loottables.LootTableType;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.utils.RandomCollection;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.event.Event;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LootTableReplacer {
    private LootTableReplacer() {
    }

    protected static void replaceContainerContent(Structure structure, Location location) {
        ItemStack paper;
        BlockState blockState = location.getBlock().getState();
        Container container = (Container)blockState;
        Inventory containerInventory = container.getInventory();
        Block block = location.getBlock();
        LootTableType blockType = LootTableType.valueOf(block.getType());
        boolean explictLoottableDefined = false;
        LootTable lootTable = null;
        if (containerInventory.getItem(0) != null && (paper = containerInventory.getItem(0)).getType() == Material.PAPER && paper.hasItemMeta() && paper.getItemMeta().hasDisplayName() && paper.getItemMeta().getDisplayName().contains("%${") && paper.getItemMeta().getDisplayName().contains("}$%")) {
            String name = paper.getItemMeta().getDisplayName().replace("%${", "").replace("}$%", "");
            lootTable = CustomStructures.getInstance().getLootTableHandler().getLootTableByName(name);
            containerInventory.clear();
            explictLoottableDefined = true;
        }
        if (lootTable == null) {
            if (structure.getLootTables().isEmpty()) {
                return;
            }
            RandomCollection<LootTable> tables = structure.getLootTables(blockType);
            if (tables == null) {
                return;
            }
            lootTable = tables.next();
        }
        Random random = new Random();
        LootPopulateEvent event = new LootPopulateEvent(structure, location, lootTable);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCanceled()) {
            return;
        }
        if ((lootTable.getTypes().contains((Object)blockType) || explictLoottableDefined) && containerInventory instanceof FurnaceInventory) {
            lootTable.fillFurnaceInventory((FurnaceInventory)containerInventory, random, container.getLocation());
        } else if ((lootTable.getTypes().contains((Object)blockType) || explictLoottableDefined) && containerInventory instanceof BrewerInventory) {
            lootTable.fillBrewerInventory((BrewerInventory)containerInventory, random, container.getLocation());
        } else if (lootTable.getTypes().contains((Object)blockType) || explictLoottableDefined) {
            lootTable.fillContainerInventory(containerInventory, random, container.getLocation());
        }
    }

    public static void replaceChestContent(LootTable lootTable, Random random, Inventory containerInventory) {
        for (int roll = 0; roll < lootTable.getRolls(); ++roll) {
            ItemStack[] containerContent = containerInventory.getContents();
            ItemStack randomItem = lootTable.getRandomWeightedItem();
            for (int j = 0; j < randomItem.getAmount(); ++j) {
                boolean done = false;
                int attemps = 0;
                while (!done) {
                    int randomPos = random.nextInt(containerContent.length);
                    ItemStack randomPosItem = containerInventory.getItem(randomPos);
                    if (randomPosItem != null) {
                        if (LootTableReplacer.isSameItem(randomPosItem, randomItem) && randomPosItem.getAmount() < randomItem.getMaxStackSize()) {
                            randomItemCopy = randomItem.clone();
                            int newAmount = randomPosItem.getAmount() + 1;
                            randomItemCopy.setAmount(newAmount);
                            containerContent[randomPos] = randomItemCopy;
                            containerInventory.setContents(containerContent);
                            done = true;
                        }
                    } else {
                        randomItemCopy = randomItem.clone();
                        randomItemCopy.setAmount(1);
                        containerContent[randomPos] = randomItemCopy;
                        containerInventory.setContents(containerContent);
                        done = true;
                    }
                    if (++attemps < containerContent.length) continue;
                    done = true;
                }
            }
        }
    }

    public static void replaceBrewerContent(LootTable lootTable, BrewerInventory containerInventory) {
        for (int roll = 0; roll < lootTable.getRolls(); ++roll) {
            ItemStack item = lootTable.getRandomWeightedItem();
            ItemStack ingredient = containerInventory.getIngredient();
            ItemStack fuel = containerInventory.getFuel();
            if (ingredient == null || ingredient.equals((Object)item)) {
                containerInventory.setIngredient(item);
                continue;
            }
            if (fuel != null && !fuel.equals((Object)item)) continue;
            containerInventory.setFuel(item);
        }
    }

    public static void replaceFurnaceContent(LootTable lootTable, FurnaceInventory containerInventory) {
        for (int roll = 0; roll < lootTable.getRolls(); ++roll) {
            ItemStack item = lootTable.getRandomWeightedItem();
            ItemStack result = containerInventory.getResult();
            ItemStack fuel = containerInventory.getFuel();
            ItemStack smelting = containerInventory.getSmelting();
            if (result == null || result.equals((Object)item)) {
                containerInventory.setResult(item);
                continue;
            }
            if (fuel == null || fuel.equals((Object)item)) {
                containerInventory.setFuel(item);
                continue;
            }
            if (smelting != null && !smelting.equals((Object)item)) continue;
            containerInventory.setSmelting(item);
        }
    }

    private static boolean isSameItem(ItemStack randomPosItem, ItemStack randomItem) {
        ItemMeta randomPosItemMeta = randomPosItem.getItemMeta();
        ItemMeta randomItemMeta = randomItem.getItemMeta();
        return randomPosItem.getType().equals((Object)randomItem.getType()) && randomPosItemMeta.equals(randomItemMeta);
    }
}

