/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.loottables.customitems;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.exceptions.LootTableException;
import com.ryandw11.structure.loottables.ConfigLootItem;
import com.ryandw11.structure.loottables.LootTable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class CustomLootItem
extends ConfigLootItem {
    private ItemStack itemStack;

    public CustomLootItem(LootTable lootTable, String itemID, int weight, String amount) {
        super(lootTable, itemID, weight, amount);
    }

    @Override
    public void constructItem(ConfigurationSection configurationSection) {
        ItemStack item = CustomStructures.getInstance().getCustomItemManager().getItem(configurationSection.getString("Key"));
        if (item == null) {
            CustomStructures.getInstance().getLogger().warning("Cannot find a custom item with the id of " + this.getItemID() + " in the " + this.getLootTable().getName() + " loot table!");
            throw new LootTableException("Cannot find a custom item with the id of " + this.getItemID() + "!");
        }
        this.itemStack = item;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack clone = this.itemStack.clone();
        clone.setAmount(this.getAmount());
        return clone;
    }
}

