/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.loottables.customitems;

import com.ryandw11.structure.CustomStructures;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class CustomItemManager {
    private FileConfiguration config;
    private File file;
    private CustomStructures structures;

    public CustomItemManager(CustomStructures structures, File file, File dir) {
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                structures.getLogger().severe("Cannot create Custom Items file. Enable debug mode for more information.");
                if (structures.isDebug()) {
                    ex.printStackTrace();
                }
                return;
            }
        }
        this.file = file;
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.structures = structures;
    }

    public boolean addItem(String key, ItemStack itemStack) {
        if (this.config.contains(key)) {
            return false;
        }
        this.config.set(key, (Object)itemStack.clone());
        try {
            this.config.save(this.file);
            return true;
        }
        catch (IOException ex) {
            this.structures.getLogger().severe("Failed to save Custom Items file after adding an item.");
            if (this.structures.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public boolean removeItem(String key) {
        if (!this.config.contains(key)) {
            return false;
        }
        this.config.set(key, null);
        try {
            this.config.save(this.file);
            return true;
        }
        catch (IOException ex) {
            this.structures.getLogger().severe("Failed to save Custom Items file after removing an item.");
            if (this.structures.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public ItemStack getItem(String key) {
        if (!this.config.contains(key)) {
            return null;
        }
        return this.config.getItemStack(key);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

