/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.loottables;

import com.ryandw11.structure.exceptions.LootTableException;
import com.ryandw11.structure.loottables.LootItem;
import com.ryandw11.structure.utils.NumberStylizer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class StandardLootItem
implements LootItem {
    private int weight;
    private final String amount;
    private final Map<String, String> enchants;
    private ItemStack item;

    public StandardLootItem(String customName, String material, int amount, int weight, List<String> lore, Map<String, String> enchants) {
        this.weight = weight;
        try {
            this.item = new ItemStack(Material.valueOf((String)material.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            throw new LootTableException("Unknown Material Type: " + material);
        }
        this.amount = "" + amount;
        this.item.setAmount(amount);
        if (customName != null) {
            ItemMeta meta = Objects.requireNonNull(this.item.getItemMeta());
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
            this.item.setItemMeta(meta);
        }
        if (!lore.isEmpty()) {
            lore = lore.stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).collect(Collectors.toList());
            Objects.requireNonNull(this.item.getItemMeta()).setLore(lore);
        }
        this.enchants = enchants;
    }

    public StandardLootItem(String customName, String material, String amount, int weight, List<String> lore, Map<String, String> enchants) {
        this.weight = weight;
        try {
            this.item = new ItemStack(Material.valueOf((String)material.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            throw new LootTableException("Unknown Material Type: " + material);
        }
        this.amount = amount;
        this.item.setAmount(NumberStylizer.getStylizedInt(amount));
        ItemMeta meta = Objects.requireNonNull(this.item.getItemMeta());
        if (customName != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)customName));
        }
        if (!lore.isEmpty()) {
            lore = lore.stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).collect(Collectors.toList());
            meta.setLore(lore);
        }
        this.item.setItemMeta(meta);
        this.enchants = enchants;
    }

    private void applyStats(ItemStack item) {
        item.setAmount(NumberStylizer.getStylizedInt(this.amount));
        for (String enchantName : this.enchants.keySet()) {
            int level = NumberStylizer.getStylizedInt(this.enchants.get(enchantName));
            Enchantment enchantment = EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchantName.toLowerCase()));
            if (enchantment == null) {
                throw new LootTableException("Invalid Enchantment: " + enchantName);
            }
            ItemMeta itemMeta = item.getItemMeta();
            if (itemMeta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta enchantmentStorageMeta = (EnchantmentStorageMeta)itemMeta;
                enchantmentStorageMeta.addStoredEnchant(enchantment, level, true);
                item.setItemMeta((ItemMeta)enchantmentStorageMeta);
                continue;
            }
            item.addUnsafeEnchantment(enchantment, level);
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack cloneStack = this.item.clone();
        this.applyStats(cloneStack);
        return cloneStack;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }
}

