/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.loottables;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;

public enum LootTableType {
    CHEST(Material.CHEST),
    FURNACE(Material.FURNACE),
    HOPPER(Material.HOPPER),
    BREWING_STAND(Material.BREWING_STAND),
    BARREL(Material.BARREL),
    TRAPPED_CHEST(Material.TRAPPED_CHEST),
    DROPPER(Material.DROPPER),
    DISPENSER(Material.DISPENSER),
    BLAST_FURNACE("BLAST_FURNACE"),
    SMOKER("SMOKER"),
    SHULKER_BOX(Material.SHULKER_BOX),
    BLACK_SHULKER_BOX(Material.BLACK_SHULKER_BOX),
    BLUE_SHULKER_BOX(Material.BLUE_SHULKER_BOX),
    BROWN_SHULKER_BOX(Material.BROWN_SHULKER_BOX),
    CYAN_SHULKER_BOX(Material.CYAN_SHULKER_BOX),
    GRAY_SHULKER_BOX(Material.GRAY_SHULKER_BOX),
    GREEN_SHULKER_BOX(Material.GREEN_SHULKER_BOX),
    LIGHT_BLUE_SHULKER_BOX(Material.LIGHT_BLUE_SHULKER_BOX),
    LIME_SHULKER_BOX(Material.LIME_SHULKER_BOX),
    MAGENTA_SHULKER_BOX(Material.MAGENTA_SHULKER_BOX),
    ORANGE_SHULKER_BOX(Material.ORANGE_SHULKER_BOX),
    PINK_SHULKER_BOX(Material.PINK_SHULKER_BOX),
    PURPLE_SHULKER_BOX(Material.PURPLE_SHULKER_BOX),
    RED_SHULKER_BOX(Material.RED_SHULKER_BOX),
    WHITE_SHULKER_BOX(Material.WHITE_SHULKER_BOX),
    YELLOW_SHULKER_BOX(Material.YELLOW_SHULKER_BOX);

    private Material material;

    private LootTableType(String materialName) {
        try {
            this.material = Material.valueOf((String)materialName);
        }
        catch (IllegalArgumentException ex) {
            this.material = Material.CHEST;
        }
    }

    private LootTableType(Material material) {
        this.material = material;
    }

    public Material getMaterial() {
        return this.material;
    }

    public static List<LootTableType> valueOfList(String value) {
        String[] splitList = value.split(",");
        ArrayList<LootTableType> output = new ArrayList<LootTableType>();
        for (String s : splitList) {
            output.add(LootTableType.valueOf(s));
        }
        return output;
    }

    public static LootTableType valueOf(Material material) {
        for (LootTableType type : LootTableType.values()) {
            if (material != type.getMaterial()) continue;
            return type;
        }
        return null;
    }

    public static boolean exists(String value) {
        for (LootTableType s : LootTableType.values()) {
            if (!s.toString().equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }
}

