/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.loottables;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.exceptions.LootTableException;
import com.ryandw11.structure.loottables.ConfigLootItem;
import com.ryandw11.structure.loottables.LootTable;
import com.ryandw11.structure.loottables.StandardLootItem;
import com.ryandw11.structure.loottables.customitems.CustomLootItem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigLootTable
extends LootTable {
    private final String name;
    private int rolls;
    public FileConfiguration lootTablesFC;

    public ConfigLootTable(String name) {
        this.loadFile(name);
        this.name = name;
        if (!this.lootTablesFC.contains("Rolls")) {
            throw new LootTableException("Invalid loot table format! Cannot find global 'Rolls' setting.");
        }
        this.rolls = this.lootTablesFC.getInt("Rolls");
        this.loadItems();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRolls() {
        return this.rolls;
    }

    @Override
    public void setRolls(int rolls) {
        this.rolls = rolls;
    }

    private void loadItems() {
        if (!this.lootTablesFC.contains("Items")) {
            throw new LootTableException("Invalid LootTable format! The 'Items' section is required!");
        }
        for (String itemID : this.lootTablesFC.getConfigurationSection("Items").getKeys(false)) {
            ConfigurationSection itemSection = this.lootTablesFC.getConfigurationSection("Items." + itemID);
            assert (itemSection != null);
            String type = itemSection.getString("Type");
            if (type == null) {
                type = "Standard";
            }
            type = type.toUpperCase();
            int weight = itemSection.getInt("Weight", 1);
            String amount = itemSection.getString("Amount", "1");
            if (type.equalsIgnoreCase("STANDARD")) {
                this.handleStandardItem(itemID, itemSection);
                continue;
            }
            if (type.equalsIgnoreCase("CUSTOM")) {
                try {
                    CustomLootItem customLootItem = new CustomLootItem(this, itemID, weight, amount);
                    customLootItem.constructItem(itemSection);
                    this.randomCollection.add(weight, customLootItem);
                }
                catch (LootTableException ex) {}
                continue;
            }
            Class<? extends ConfigLootItem> itemClass = CustomStructures.getInstance().getLootTableHandler().getLootItemClassByName(type);
            if (itemClass == null) {
                throw new LootTableException(String.format("Unable to find custom loot item type %s!", type));
            }
            try {
                Constructor<? extends ConfigLootItem> item = itemClass.getConstructor(LootTable.class, String.class, Integer.TYPE, String.class);
                ConfigLootItem itemInst = item.newInstance(this, itemID, weight, amount);
                itemInst.constructItem(itemSection);
                this.randomCollection.add(weight, itemInst);
            }
            catch (NoSuchMethodException ex) {
                throw new LootTableException(String.format("Unable to construct custom loot item type %s! Does the required constructor exist?", type));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
                throw new LootTableException(String.format("Unable to construct custom loot item type %s! Does the constructor have the correct access level?", type));
            }
        }
    }

    private void handleStandardItem(String itemID, ConfigurationSection section) {
        this.validateItem(itemID, section);
        String customName = section.getString("Name");
        String material = Objects.requireNonNull(section.getString("Material"));
        String amount = Objects.requireNonNull(section.getString("Amount"));
        int weight = section.getInt("Weight");
        HashMap<String, String> enchants = new HashMap<String, String>();
        ConfigurationSection enchantMents = section.getConfigurationSection("Enchantments");
        if (enchantMents != null) {
            for (String enchantName : enchantMents.getKeys(false)) {
                String level = Objects.requireNonNull(section.getString("Enchantments." + enchantName));
                enchants.put(enchantName, level);
            }
        }
        List lore = section.getStringList("Lore");
        this.randomCollection.add(weight, new StandardLootItem(customName, material, amount, weight, (List<String>)lore, enchants));
    }

    private void validateItem(String itemID, ConfigurationSection item) {
        if (item == null) {
            throw new LootTableException("Invalid file format for loot table!");
        }
        if (!item.contains("Amount")) {
            throw new LootTableException("Invalid file format for loot table! Cannot find 'Amount' setting for item: " + itemID);
        }
        if (!item.contains("Weight")) {
            throw new LootTableException("Invalid file format for loot table! Cannot find 'Weight' setting for item: " + itemID);
        }
        if (!item.contains("Type")) {
            throw new LootTableException("Invalid file format for loot table! Cannot find 'Type' setting for item: " + itemID);
        }
        if (!item.isInt("Weight")) {
            throw new LootTableException("Invalid file format for loot table! 'Weight' is not an integer for item: " + itemID);
        }
    }

    private void loadFile(String name) {
        File lootTablesfile = new File(CustomStructures.plugin.getDataFolder() + "/lootTables/" + name + ".yml");
        if (!lootTablesfile.exists()) {
            throw new LootTableException("Cannot find the following loot table file: " + name);
        }
        this.lootTablesFC = YamlConfiguration.loadConfiguration((File)lootTablesfile);
        try {
            this.lootTablesFC.load(lootTablesfile);
        }
        catch (IOException | InvalidConfigurationException e) {
            throw new LootTableException("Invalid LootTable Configuration! Please view the guide on the wiki for more information.");
        }
    }
}

