/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.io;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.exceptions.RateLimitException;
import com.ryandw11.structure.exceptions.StructureDatabaseException;
import com.ryandw11.structure.exceptions.StructureNotFoundException;
import com.ryandw11.structure.io.NearbyStructuresRequest;
import com.ryandw11.structure.io.NearbyStructuresResponse;
import com.ryandw11.structure.io.sql.DistanceFunction;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.utils.Pair;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.sqlite.Function;

public class StructureDatabaseHandler
extends BukkitRunnable {
    private final Map<Location, Structure> structuresToSave = new ConcurrentHashMap<Location, Structure>();
    private final List<Pair<Location, CompletableFuture<Structure>>> structuresToGet = new CopyOnWriteArrayList<Pair<Location, CompletableFuture<Structure>>>();
    private final List<Pair<Structure, CompletableFuture<List<Location>>>> locationsToGet = new CopyOnWriteArrayList<Pair<Structure, CompletableFuture<List<Location>>>>();
    private final List<Pair<NearbyStructuresRequest, CompletableFuture<NearbyStructuresResponse>>> findNearby = new CopyOnWriteArrayList<Pair<NearbyStructuresRequest, CompletableFuture<NearbyStructuresResponse>>>();
    private final Connection connection;
    private final CustomStructures plugin;

    public StructureDatabaseHandler(CustomStructures plugin) {
        this.plugin = plugin;
        File dataDirectory = new File(plugin.getDataFolder() + "/data/");
        if (!dataDirectory.exists() && !dataDirectory.mkdir()) {
            throw new StructureDatabaseException("Unable to create 'data' folder. Does the plugin have the correct permissions?");
        }
        try {
            this.connection = DriverManager.getConnection(String.format("jdbc:sqlite:%s", plugin.getDataFolder() + "/data/structures.db"));
            Function.create((Connection)this.connection, (String)"DIST", (Function)new DistanceFunction());
            Statement statement = this.connection.createStatement();
            statement.setQueryTimeout(30);
            statement.executeUpdate("CREATE TABLE IF NOT EXISTS Structures (\n    id INTEGER PRIMARY KEY,\n    name VARCHAR(100) NOT NULL,\n    x DOUBLE NOT NULL,\n    y DOUBLE NOT NULL,\n    z DOUBLE NOT NULL,\n    world VARCHAR(300) NOT NULL\n)\n");
            statement.close();
        }
        catch (SQLException exception) {
            if (plugin.isDebug()) {
                exception.printStackTrace();
            }
            throw new StructureDatabaseException("Unable to connect to SQLite database.");
        }
    }

    public void addStructure(Location loc, Structure structure) {
        this.structuresToSave.put(loc, structure);
    }

    public CompletableFuture<Structure> getStructure(Location location) {
        CompletableFuture<Structure> completableFuture = new CompletableFuture<Structure>();
        this.structuresToGet.add(Pair.of(location, completableFuture));
        return completableFuture;
    }

    public CompletableFuture<NearbyStructuresResponse> findNearby(NearbyStructuresRequest request) {
        CompletableFuture<NearbyStructuresResponse> completableFuture = new CompletableFuture<NearbyStructuresResponse>();
        if (this.findNearby.size() <= 5) {
            this.findNearby.add(Pair.of(request, completableFuture));
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> completableFuture.completeExceptionally(new RateLimitException("The maximum amount of requests has been hit.")), 5L);
        }
        return completableFuture;
    }

    public CompletableFuture<List<Location>> getStructureLocations(Structure structure) {
        CompletableFuture<List<Location>> completableFuture = new CompletableFuture<List<Location>>();
        this.locationsToGet.add(Pair.of(structure, completableFuture));
        return completableFuture;
    }

    public void run() {
        ArrayList<NearbyStructuresResponse.NearbyStructureContainer> result;
        PreparedStatement statement;
        for (Map.Entry<Location, Structure> entry : this.structuresToSave.entrySet()) {
            String worldName = Objects.requireNonNull(entry.getKey().getWorld()).getName();
            try {
                statement = this.connection.prepareStatement("INSERT INTO Structures (name, x, y, z, world) VALUES (?, ?, ?, ?, ?)");
                statement.setString(1, entry.getValue().getName());
                statement.setDouble(2, entry.getKey().getBlockX());
                statement.setDouble(3, entry.getKey().getBlockY());
                statement.setDouble(4, entry.getKey().getBlockZ());
                statement.setString(5, worldName);
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException exception) {
                if (!this.plugin.isDebug()) continue;
                this.plugin.getLogger().warning("An error was encountered when attempting to save a structure to the structure database!");
                exception.printStackTrace();
            }
        }
        this.structuresToSave.clear();
        for (Pair pair : this.structuresToGet) {
            try {
                PreparedStatement statement2 = this.connection.prepareStatement("SELECT name FROM Structures WHERE x = ? AND y = ? AND z = ? AND world = ?");
                statement2.setDouble(1, ((Location)pair.getLeft()).getBlockX());
                statement2.setDouble(2, ((Location)pair.getLeft()).getBlockY());
                statement2.setDouble(3, ((Location)pair.getLeft()).getBlockZ());
                statement2.setString(4, Objects.requireNonNull(((Location)pair.getLeft()).getWorld()).getName());
                ResultSet resultSet = statement2.executeQuery();
                if (resultSet.next()) {
                    Structure structure = this.plugin.getStructureHandler().getStructure(resultSet.getString("name"));
                    if (structure != null) {
                        ((CompletableFuture)pair.getRight()).complete(structure);
                        continue;
                    }
                    ((CompletableFuture)pair.getRight()).completeExceptionally(new StructureNotFoundException("Retrieved structure is not loaded!"));
                    continue;
                }
                ((CompletableFuture)pair.getRight()).completeExceptionally(new StructureNotFoundException("Cannot find structure with the provided location."));
            }
            catch (SQLException exception) {
                ((CompletableFuture)pair.getRight()).completeExceptionally(new StructureDatabaseException("An error was encountered when attempting to retrieve a structure from the structure database!"));
                if (!this.plugin.isDebug()) continue;
                this.plugin.getLogger().warning("An error was encountered when attempting to retrieve a structure from the structure database!");
                exception.printStackTrace();
            }
        }
        this.structuresToGet.clear();
        for (Pair pair : this.locationsToGet) {
            result = new ArrayList<NearbyStructuresResponse.NearbyStructureContainer>();
            try {
                statement = this.connection.prepareStatement("SELECT * FROM Structures WHERE name = ?");
                statement.setString(1, ((Structure)pair.getLeft()).getName());
                ResultSet resultSet = statement.executeQuery();
                while (resultSet.next()) {
                    result.add((NearbyStructuresResponse.NearbyStructureContainer)new Location(Bukkit.getWorld((String)resultSet.getString("world")), resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z")));
                }
                ((CompletableFuture)pair.getRight()).complete(result);
            }
            catch (SQLException exception) {
                ((CompletableFuture)pair.getRight()).completeExceptionally(new StructureDatabaseException("An error was encountered when attempting to retrieve structures from the structure database!"));
                if (!this.plugin.isDebug()) continue;
                this.plugin.getLogger().warning("An error was encountered when attempting to retrieve structures from the structure database!");
                exception.printStackTrace();
            }
        }
        this.locationsToGet.clear();
        for (Pair pair : this.findNearby) {
            try {
                result = new ArrayList();
                NearbyStructuresRequest nearbyStructuresRequest = (NearbyStructuresRequest)pair.getLeft();
                PreparedStatement statement3 = null;
                if (nearbyStructuresRequest.hasName()) {
                    statement3 = this.connection.prepareStatement("SELECT *, DIST(?, ?, ?, x, y, z) AS dist FROM Structures WHERE name = ? AND world = ? ORDER BY dist ASC LIMIT ?");
                    statement3.setInt(1, nearbyStructuresRequest.getLocation().getBlockX());
                    statement3.setInt(2, nearbyStructuresRequest.getLocation().getBlockY());
                    statement3.setInt(3, nearbyStructuresRequest.getLocation().getBlockZ());
                    statement3.setString(4, nearbyStructuresRequest.getName());
                    statement3.setString(5, Objects.requireNonNull(nearbyStructuresRequest.getLocation().getWorld()).getName());
                    statement3.setInt(6, nearbyStructuresRequest.getLimit());
                } else {
                    statement3 = this.connection.prepareStatement("SELECT *, DIST(?, ?, ?, x, y, z) AS dist FROM Structures WHERE world = ? ORDER BY dist ASC LIMIT ?");
                    statement3.setInt(1, nearbyStructuresRequest.getLocation().getBlockX());
                    statement3.setInt(2, nearbyStructuresRequest.getLocation().getBlockY());
                    statement3.setInt(3, nearbyStructuresRequest.getLocation().getBlockZ());
                    statement3.setString(4, Objects.requireNonNull(nearbyStructuresRequest.getLocation().getWorld()).getName());
                    statement3.setInt(5, nearbyStructuresRequest.getLimit());
                }
                ResultSet resultSet = statement3.executeQuery();
                while (resultSet.next()) {
                    result.add(new NearbyStructuresResponse.NearbyStructureContainer(new Location(Bukkit.getWorld((String)resultSet.getString("world")), resultSet.getDouble("x"), resultSet.getDouble("y"), resultSet.getDouble("z")), this.plugin.getStructureHandler().getStructure(resultSet.getString("name")), resultSet.getDouble("dist")));
                }
                ((CompletableFuture)pair.getRight()).complete(new NearbyStructuresResponse(result));
            }
            catch (SQLException ex) {
                ((CompletableFuture)pair.getRight()).completeExceptionally(new StructureDatabaseException("An error was encountered when attempting to retrieve structures from the structure database!"));
                if (!this.plugin.isDebug()) continue;
                this.plugin.getLogger().warning("An error was encountered when attempting to retrieve structures from the structure database! (Nearby)");
                ex.printStackTrace();
            }
        }
        this.findNearby.clear();
    }

    public synchronized void cancel() throws IllegalStateException {
        block2: {
            this.run();
            super.cancel();
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                if (!this.plugin.isDebug()) break block2;
                this.plugin.getLogger().warning("An error was encountered when attempting to close the database connection!");
                ex.printStackTrace();
            }
        }
    }
}

