/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.commands.cstruct;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.commands.SubCommand;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks;
import com.ryandw11.structure.structure.Structure;
import com.ryandw11.structure.structure.properties.BlockLevelLimit;
import com.ryandw11.structure.structure.properties.StructureYSpawning;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TestSpawnCommand
implements SubCommand {
    private final CustomStructures plugin;

    public TestSpawnCommand(CustomStructures plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean subCommand(CommandSender sender, Command cmd, String s, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(ChatColor.RED + "Invalid arguments. /cstruct testspawn {name}");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command is for players only!");
            return true;
        }
        Player p = (Player)sender;
        if (!p.hasPermission("customstructures.test.spawn")) {
            p.sendMessage(ChatColor.RED + "You do not have permission for this command.");
            return true;
        }
        Structure structure = this.plugin.getStructureHandler().getStructure(args[0]);
        if (structure == null) {
            p.sendMessage(ChatColor.RED + "That structure does not exist!");
            return true;
        }
        p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&b=================[&6" + structure.getName() + "&b]=================")));
        this.psuedoCalculate(p, structure, p.getLocation().getBlock(), p.getLocation().getChunk());
        p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&b=================[&6" + structure.getName() + "&b]=================")));
        return true;
    }

    void psuedoCalculate(Player p, Structure structure, Block bl, Chunk ch) {
        IgnoreBlocks ignoreBlocks = this.plugin.getBlockIgnoreManager();
        StructureYSpawning structureSpawnSettings = structure.getStructureLocation().getSpawnSettings();
        bl = structureSpawnSettings.getHighestBlock(bl.getLocation());
        this.canSpawn(p, structure, bl, ch);
        if (structure.getStructureProperties().isIgnoringPlants() && ignoreBlocks.getBlocks().contains(bl.getType())) {
            for (int i = bl.getY(); i >= 4; --i) {
                if (ignoreBlocks.getBlocks().contains(ch.getBlock(8, i, 8).getType()) || ch.getBlock(8, i, 8).getType().isAir()) continue;
                bl = ch.getBlock(8, i, 8);
                break;
            }
        }
        if (structureSpawnSettings.isCalculateSpawnYFirst()) {
            bl = ch.getBlock(8, structureSpawnSettings.getHeight(bl.getLocation()), 8);
            this.quickSendMessage(p, "&aSpawn Y Value: " + bl.getY());
        }
        if (!structure.getStructureLimitations().hasWhitelistBlock(bl)) {
            this.quickSendMessage(p, String.format("&cFailed Block Limitation! Cannot spawn on %s! (Whitelist Defined)", bl.getType()));
            return;
        }
        if (structure.getStructureLimitations().hasBlacklistBlock(bl)) {
            this.quickSendMessage(p, String.format("&cFailed Block Limitation! Cannot spawn on %s! (Blacklist Defined)", bl.getType()));
            return;
        }
        if (!structure.getStructureProperties().canSpawnInWater() && bl.getType() == Material.WATER) {
            this.quickSendMessage(p, "&cFailed Water test! Cannot spawn in the water!");
            return;
        }
        if (!structure.getStructureProperties().canSpawnInLavaLakes() && bl.getType() == Material.LAVA) {
            this.quickSendMessage(p, "&cFailed Lava test! Cannot spawn in the lava!");
            return;
        }
        if (!structureSpawnSettings.isCalculateSpawnYFirst()) {
            bl = ch.getBlock(8, structureSpawnSettings.getHeight(bl.getLocation()), 8);
            this.quickSendMessage(p, "&aSpawn Y Value: " + bl.getY());
        }
        if (structure.getStructureLimitations().getWorldHeightRestriction() != -1 && bl.getLocation().getY() > (double)(ch.getWorld().getMaxHeight() - structure.getStructureLimitations().getWorldHeightRestriction())) {
            this.quickSendMessage(p, "&cFailed World Height Restriction!");
            return;
        }
        if (structure.getStructureLimitations().getBlockLevelLimit().isEnabled()) {
            BlockLevelLimit limit = structure.getStructureLimitations().getBlockLevelLimit();
            if (limit.getMode().equalsIgnoreCase("flat")) {
                for (int x = limit.getX1() + bl.getX(); x <= limit.getX2() + bl.getX(); ++x) {
                    for (int z = limit.getZ1() + bl.getZ(); z <= limit.getZ2() + bl.getZ(); ++z) {
                        Block top = ch.getWorld().getBlockAt(x, bl.getY() + 1, z);
                        Block bottom = ch.getWorld().getBlockAt(x, bl.getY() - 1, z);
                        if (!top.getType().isAir() && !ignoreBlocks.getBlocks().contains(top.getType())) {
                            if (this.plugin.isDebug()) {
                                p.sendMessage(top.getLocation() + " || TOP FAIL");
                                p.sendMessage(top.getType() + " || TOP FAIL");
                            }
                            this.quickSendMessage(p, "&cFailed Flat Block Level Limit test! The ground is not flat!");
                            return;
                        }
                        if (!bottom.getType().isAir()) continue;
                        if (this.plugin.isDebug()) {
                            p.sendMessage(bottom.getLocation() + " || BOTTOM FAIL");
                        }
                        this.quickSendMessage(p, "&cFailed Flat Block Level Limit test! The ground is not flat!");
                        return;
                    }
                }
            } else if (limit.getMode().equalsIgnoreCase("flat_error")) {
                int total = 0;
                int error = 0;
                for (int x = limit.getX1() + bl.getX(); x <= limit.getX2() + bl.getX(); ++x) {
                    for (int z = limit.getZ1() + bl.getZ(); z <= limit.getZ2() + bl.getZ(); ++z) {
                        Block top = ch.getWorld().getBlockAt(x, bl.getY() + 1, z);
                        Block bottom = ch.getWorld().getBlockAt(x, bl.getY() - 1, z);
                        if (!top.getType().isAir() && !ignoreBlocks.getBlocks().contains(top.getType())) {
                            ++error;
                        }
                        if (bottom.getType().isAir()) {
                            ++error;
                        }
                        total += 2;
                    }
                }
                if (this.plugin.isDebug()) {
                    p.sendMessage("Percent Failure: " + (double)error / (double)total + " / " + limit.getError());
                }
                if ((double)error / (double)total > limit.getError()) {
                    this.quickSendMessage(p, "&cFailed Flat Error Block Level Limit test! The ground is not flat enough!");
                }
            }
        }
    }

    void canSpawn(Player p, Structure structure, Block block, Chunk chunk) {
        if (!structure.getStructureLocation().getWorlds().isEmpty() && !structure.getStructureLocation().getWorlds().contains(chunk.getWorld().getName())) {
            this.quickSendMessage(p, "&cFailed world test! Cannot spawn in current world!");
        }
        if (Math.abs(block.getX()) < structure.getStructureLocation().getXLimitation()) {
            this.quickSendMessage(p, "&cFailed X Limitation test! Cannot spawn this close to (0, 0)!");
        }
        if (Math.abs(block.getZ()) < structure.getStructureLocation().getZLimitation()) {
            this.quickSendMessage(p, "&cFailed Z Limitation test! Cannot spawn this close to (0, 0)!");
        }
        if (!CustomStructures.getInstance().getStructureHandler().validDistance(structure, block.getLocation())) {
            this.quickSendMessage(p, "&cFailed Distance Limitation test! Cannot spawn this close to another structure!");
        }
        if (!CustomStructures.getInstance().getStructureHandler().validSameDistance(structure, block.getLocation())) {
            this.quickSendMessage(p, "&cFailed Distance Limitation test! Cannot spawn this close to the same structure!");
        }
        if (ThreadLocalRandom.current().nextInt(0, structure.getProbabilityDenominator() + 1) > structure.getProbabilityNumerator()) {
            this.quickSendMessage(p, String.format("&eDid not spawn by probability! (%d/%d chance)", structure.getProbabilityNumerator(), structure.getProbabilityDenominator()));
        }
        if (!structure.getStructureLocation().hasBiome(block.getBiome())) {
            this.quickSendMessage(p, "&cFailed Biome test! Cannot spawn in this biome!");
        }
    }

    void quickSendMessage(Player p, String msg) {
        p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
    }
}

