/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.commands.cstruct;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.commands.SubCommand;
import com.ryandw11.structure.loottables.LootTable;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TestLootTableCommand
implements SubCommand {
    private final CustomStructures plugin;

    public TestLootTableCommand(CustomStructures plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean subCommand(CommandSender sender, Command cmd, String s, String[] args) {
        if (args.length == 0) {
            if (!sender.hasPermission("customstructures.test.loottable")) {
                sender.sendMessage(ChatColor.RED + "You do not have permission for this command!");
                return true;
            }
            sender.sendMessage(ChatColor.RED + "You must specify the loot table for the chest to have.");
        } else if (args.length == 1) {
            if (!sender.hasPermission("customstructures.test.loottable")) {
                sender.sendMessage(ChatColor.RED + "You do not have permission for this command!");
                return true;
            }
            CommandSender commandSender = sender;
            if (!(commandSender instanceof Player)) {
                sender.sendMessage(ChatColor.RED + "This command is for players only!");
                return true;
            }
            Player p = (Player)commandSender;
            LootTable lootTable = this.plugin.getLootTableHandler().getLootTableByName(args[0]);
            if (lootTable == null) {
                sender.sendMessage(ChatColor.RED + "Cannot find specified loot table. Check to make sure that it exists.");
                return true;
            }
            Block block = p.getTargetBlock(null, 20);
            BlockState blockState = block.getState();
            if (!(blockState instanceof Container)) {
                sender.sendMessage(ChatColor.RED + "You must be looking at a container to set its loot table.");
                return true;
            }
            Container container = (Container)blockState;
            container.getInventory().clear();
            lootTable.fillContainerInventory(container.getInventory(), new Random(), container.getLocation());
            sender.sendMessage(ChatColor.GREEN + "The loot table has been applied to the container!");
        }
        return false;
    }
}

