/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.commands;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.commands.CommandHandler;
import com.ryandw11.structure.commands.cstruct.AddItemCommand;
import com.ryandw11.structure.commands.cstruct.AddonsCommand;
import com.ryandw11.structure.commands.cstruct.CheckKeyCommand;
import com.ryandw11.structure.commands.cstruct.CreateCommand;
import com.ryandw11.structure.commands.cstruct.CreateSchematicCommand;
import com.ryandw11.structure.commands.cstruct.GetItemCommand;
import com.ryandw11.structure.commands.cstruct.ListCommand;
import com.ryandw11.structure.commands.cstruct.NearbyCommand;
import com.ryandw11.structure.commands.cstruct.ReloadCommand;
import com.ryandw11.structure.commands.cstruct.SetLoottableCommand;
import com.ryandw11.structure.commands.cstruct.TestCommand;
import com.ryandw11.structure.commands.cstruct.TestLootTableCommand;
import com.ryandw11.structure.commands.cstruct.TestSpawnCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class SCommand
implements CommandExecutor {
    private final CustomStructures plugin;
    private final CommandHandler commandHandler;

    public SCommand(CustomStructures plugin) {
        this.plugin = plugin;
        this.commandHandler = new CommandHandler();
        this.commandHandler.registerCommand("test", new TestCommand(plugin));
        this.commandHandler.registerCommand("reload", new ReloadCommand(plugin));
        this.commandHandler.registerCommand("list", new ListCommand(plugin));
        this.commandHandler.registerCommand("nearby", new NearbyCommand(plugin));
        this.commandHandler.registerCommand("additem", new AddItemCommand(plugin));
        this.commandHandler.registerCommand("checkkey", new CheckKeyCommand(plugin));
        this.commandHandler.registerCommand("getitem", new GetItemCommand(plugin));
        this.commandHandler.registerCommand("createschem", new CreateSchematicCommand());
        this.commandHandler.registerCommand("create", new CreateCommand(plugin));
        this.commandHandler.registerCommand("testspawn", new TestSpawnCommand(plugin));
        this.commandHandler.registerCommand(new AddonsCommand(plugin), "addon", "addons");
        this.commandHandler.registerCommand(new SetLoottableCommand(plugin), "setloottable", "setloot", "setlt");
        this.commandHandler.registerCommand(new TestLootTableCommand(plugin), "testloottable", "testloot", "testlt");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String s, String[] args) {
        String currentPage;
        if (!CustomStructures.enabled) {
            sender.sendMessage(ChatColor.RED + "One of your schematic or loot table files could not be found!");
            sender.sendMessage(ChatColor.RED + "Please check to see if all of your files are in the proper folders!");
            sender.sendMessage(ChatColor.RED + "To find out more, see the error in the console.");
            return true;
        }
        try {
            if (args.length != 0 && !args[0].equals("1") && !args[0].equals("2")) {
                return this.commandHandler.handleCommand(sender, cmd, s, args);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String string = currentPage = args.length > 0 ? args[0] : "1";
        if (sender.hasPermission("customstructures.info")) {
            if (currentPage.equals("2")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3=============[&2CustomStructures Page 2&3]============="));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure list - &2List the currently active structures."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure addItem {key} - &2Add an item to the custom items list."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure checkKey - &2Get the key of an item you are holding in your hand."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure getItem {key} - &2Get the item of the key specified."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure createschem {name} [-options] - &2Create a schematic from the current worldedit selection (This is automatically save to the CustomStructures schematic folder)."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure create {name} {schematic} - &2Create a structure using the default settings."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure addons - &2The list of addons."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure setLootTable - &2Easily specify a loot table for a container."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure testLootTable - &2Test a loot table on a container."));
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3=============[&2CustomStructures&3]============="));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3Created by: &2Ryandw11"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&3Version: &2" + this.plugin.getDescription().getVersion())));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3Github wiki:&2 https://github.com/ryandw11/CustomStructures/wiki"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3Commands:"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure reload - &2Reload the plugin."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure test {name} - &2Paste the defined structure."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure testspawn {name} - &2Test the spawn conditions of a structure."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&3/cstructure nearby [name] [limit] - &2Find nearby structures."));
                sender.sendMessage("");
                sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&2Use &3/cstructure 2 &2to view the second page of commands!"));
            }
        } else {
            sender.sendMessage(ChatColor.RED + "You do not have permission for this command.");
        }
        return false;
    }
}

