/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.commands;

import com.ryandw11.structure.commands.SubCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandHandler {
    private final Map<List<String>, SubCommand> commandMap = new HashMap<List<String>, SubCommand>();

    public void registerCommand(String s, SubCommand subCommand) {
        if (this.commandMap.containsKey(Collections.singletonList(s.toLowerCase()))) {
            throw new IllegalArgumentException("Command already exists!");
        }
        this.commandMap.put(Collections.singletonList(s.toLowerCase()), subCommand);
    }

    public void registerCommand(SubCommand subCommand, String ... args) {
        List<String> list = new ArrayList<String>(Arrays.asList(args));
        if (this.commandMap.containsKey(list = list.stream().map(String::toLowerCase).collect(Collectors.toList()))) {
            throw new IllegalArgumentException("Command already exists!");
        }
        this.commandMap.put(list, subCommand);
    }

    public boolean handleCommand(CommandSender sender, Command cmd, String s, String[] args) {
        if (args.length == 0) {
            return false;
        }
        for (Map.Entry<List<String>, SubCommand> entry : this.commandMap.entrySet()) {
            if (!entry.getKey().contains(args[0].toLowerCase())) continue;
            String[] newArgs = new String[args.length - 1];
            if (newArgs.length > 0) {
                System.arraycopy(args, 1, newArgs, 0, newArgs.length);
            }
            return entry.getValue().subCommand(sender, cmd, s, newArgs);
        }
        throw new IllegalArgumentException("Invalid command");
    }
}

