/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.citizens;

import com.google.gson.Gson;
import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.NpcHandler;
import com.ryandw11.structure.citizens.CitizensNpcHook;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.trait.CommandTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class CitizensEnabled
implements CitizensNpcHook {
    private static final Map<String, Map<String, Object>> skinDataCache = new HashMap<String, Map<String, Object>>();
    private static final Map<String, Object> INVALID = new HashMap<String, Object>();
    private final CustomStructures plugin;

    public CitizensEnabled(CustomStructures plugin) {
        this.plugin = plugin;
    }

    @Override
    public void spawnNpc(NpcHandler npcHandler, String name, Location loc) {
        NpcHandler.NpcInfo info = npcHandler.getNPCByName(name);
        if (info == null) {
            this.plugin.getLogger().warning("Failed to spawn NPC '" + name + "', no configuration found.");
            return;
        }
        EntityType type = EntityType.VILLAGER;
        try {
            type = EntityType.valueOf((String)info.entityType);
        }
        catch (IllegalArgumentException ex) {
            this.plugin.getLogger().warning("Unsupported NPC entity-type '" + info.entityType + "'! Spawning a villager instead.");
        }
        String npcName = CustomStructures.replacePAPIPlaceholders(info.name);
        NPC npc = CitizensAPI.getNPCRegistry().createNPC(type, npcName);
        int npcId = npc.getId();
        if (!npc.isSpawned()) {
            npc.spawn(loc.add(0.5, 0.0, 0.5));
        }
        npc.setProtected(info.isProtected);
        npc.setUseMinecraftAI(info.movesAround);
        LookClose lookClose = (LookClose)npc.getOrAddTrait(LookClose.class);
        lookClose.lookClose(info.looksAtPlayer);
        if (!info.commandsOnCreate.isEmpty()) {
            for (String command : info.commandsOnCreate) {
                command = command.trim();
                command = command.replace("<npcid>", String.valueOf(npcId));
                if ((command = CustomStructures.replacePAPIPlaceholders(command)).toUpperCase().startsWith("[PLAYER]")) {
                    command = command.substring(8);
                    this.plugin.getLogger().warning("Ignoring [PLAYER] prefix for 'commandsOnCreate' commands!");
                }
                this.plugin.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
                if (!this.plugin.isDebug()) continue;
                this.plugin.getLogger().info("[DEBUG] Executing command for newly created NPC: '" + command + "'");
            }
        }
        if (!info.commandsOnClick.isEmpty()) {
            for (String command : info.commandsOnClick) {
                command = command.trim();
                boolean isPlayerCommand = (command = command.replace("<npcid>", String.valueOf(npcId))).toUpperCase().startsWith("[PLAYER]");
                if (isPlayerCommand) {
                    command = command.substring(8);
                }
                CommandTrait commandTrait = (CommandTrait)npc.getOrAddTrait(CommandTrait.class);
                CommandTrait.NPCCommandBuilder cmdBuilder = new CommandTrait.NPCCommandBuilder(command, CommandTrait.Hand.RIGHT);
                cmdBuilder.op(true);
                if (isPlayerCommand) {
                    cmdBuilder.player(true);
                }
                commandTrait.addCommand(cmdBuilder);
                commandTrait.setExecutionMode(info.commandsSequential ? CommandTrait.ExecutionMode.SEQUENTIAL : CommandTrait.ExecutionMode.LINEAR);
                if (!this.plugin.isDebug()) continue;
                this.plugin.getLogger().info("[DEBUG] Set on-click command for NPC: '" + command + "'");
            }
        }
        if (type == EntityType.PLAYER && info.skinUrl != null && !info.skinUrl.isEmpty()) {
            this.changeSkin(npc, info.skinUrl);
        }
        npc.setBukkitEntityType(EntityType.valueOf((String)info.entityType));
    }

    private void changeSkin(NPC npc, String url) {
        Map<String, Object> skinData = skinDataCache.get(url);
        if (skinData == null) {
            skinData = this.downloadFromMineskinOrg(url);
            if (skinData == null) {
                skinDataCache.put(url, INVALID);
            } else {
                skinDataCache.put(url, skinData);
            }
        }
        if (skinData != null && skinData != INVALID) {
            try {
                Map data = (Map)skinData.get("data");
                String uuid = (String)data.get("uuid");
                Map texture = (Map)data.get("texture");
                String textureEncoded = (String)texture.get("value");
                String signature = (String)texture.get("signature");
                SkinTrait trait = (SkinTrait)npc.getOrAddTrait(SkinTrait.class);
                trait.setSkinPersistent(uuid, signature, textureEncoded);
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Failed to set skin for " + npc.getName() + ", probably invalid / corrupt skin data.");
                if (this.plugin.isDebug()) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.plugin.getLogger().warning("Failed to retrieve skin for npc: " + npc.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> downloadFromMineskinOrg(String url) {
        FilterOutputStream out = null;
        BufferedReader reader = null;
        try {
            if (this.plugin.isDebug()) {
                this.plugin.getLogger().info("[DEBUG] Downloading NPC skin: " + url + " from ");
            }
            URL target = new URL("https://api.mineskin.org/generate/url");
            HttpURLConnection con = (HttpURLConnection)target.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setConnectTimeout(1000);
            con.setReadTimeout(30000);
            out = new DataOutputStream(con.getOutputStream());
            ((DataOutputStream)out).writeBytes("url=" + URLEncoder.encode(url, "UTF-8"));
            out.close();
            reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
            Map skinInfo = (Map)new Gson().fromJson((Reader)reader, Map.class);
            con.disconnect();
            Map map = skinInfo;
            return map;
        }
        catch (Exception ex) {
            this.plugin.getLogger().warning("Failed to download NPC skin: " + url + ".");
            if (this.plugin.isDebug()) {
                ex.printStackTrace();
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

