/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure.api.structaddon;

import com.ryandw11.structure.CustomStructures;
import com.ryandw11.structure.api.structaddon.StructureSection;
import com.ryandw11.structure.api.structaddon.StructureSectionProvider;
import com.ryandw11.structure.api.structaddon.StructureSign;
import com.ryandw11.structure.loottables.ConfigLootItem;
import com.ryandw11.structure.loottables.LootTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.Plugin;

public final class CustomStructureAddon {
    private final String name;
    private final List<String> authors;
    private final Set<StructureSectionProvider> providerSet = new HashSet<StructureSectionProvider>();
    private final List<Class<? extends StructureSection>> structureSections;
    private final List<LootTable> lootTables;
    private final Map<String, Class<? extends ConfigLootItem>> lootItems;

    public CustomStructureAddon(Plugin plugin) {
        if (plugin == CustomStructures.getInstance()) {
            throw new IllegalArgumentException("Cannot add CustomStructures as an addon.");
        }
        this.name = plugin.getName();
        if (this.name.equalsIgnoreCase("CustomStructures") || this.name.equalsIgnoreCase("CustomStructure")) {
            throw new IllegalArgumentException("Addon name cannot be the same as the plugin.");
        }
        this.structureSections = new ArrayList<Class<? extends StructureSection>>();
        this.lootTables = new ArrayList<LootTable>();
        this.lootItems = new HashMap<String, Class<? extends ConfigLootItem>>();
        this.authors = plugin.getDescription().getAuthors();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void addStructureSection(Class<? extends StructureSection> structureSection) {
        this.structureSections.add(structureSection);
    }

    public void registerStructureSectionProvider(StructureSectionProvider provider) {
        this.providerSet.add(provider);
    }

    public void unregisterStructureSectionProvider(StructureSectionProvider provider) {
        this.providerSet.remove(provider);
    }

    public List<Class<? extends StructureSection>> getStructureSections() {
        return this.structureSections;
    }

    public Set<StructureSectionProvider> getProviderSet() {
        return Collections.unmodifiableSet(this.providerSet);
    }

    public boolean registerStructureSign(String name, Class<? extends StructureSign> structureSign) {
        return CustomStructures.getInstance().getStructureSignHandler().registerStructureSign(name, structureSign);
    }

    public void registerLootTable(LootTable lootTable) {
        CustomStructures.getInstance().getLootTableHandler().addLootTable(lootTable);
        this.lootTables.add(lootTable);
    }

    public void registerLootItem(String typeName, Class<? extends ConfigLootItem> lootItemClass) {
        CustomStructures.getInstance().getLootTableHandler().addLootItem(typeName, lootItemClass);
        this.lootItems.put(typeName, lootItemClass);
    }

    public void handlePluginReload() {
        for (LootTable lootTable : this.lootTables) {
            CustomStructures.getInstance().getLootTableHandler().addLootTable(lootTable);
        }
        for (Map.Entry entry : this.lootItems.entrySet()) {
            CustomStructures.getInstance().getLootTableHandler().addLootItem((String)entry.getKey(), (Class)entry.getValue());
        }
    }
}

