/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure;

import com.ryandw11.structure.CustomStructures;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class SignCommandsHandler {
    private final Map<String, List<String>> signCommands;

    public SignCommandsHandler(File dataFolder, CustomStructures plugin) {
        YamlConfiguration yamlConfiguration;
        block5: {
            this.signCommands = new HashMap<String, List<String>>();
            yamlConfiguration = new YamlConfiguration();
            File signCommandsFile = new File(dataFolder, "signcommands.yml");
            if (!signCommandsFile.exists()) {
                plugin.getLogger().warning("Warning: Cannot find signcommands.yml. This might be a configuration error.");
                return;
            }
            try {
                yamlConfiguration.load(signCommandsFile);
            }
            catch (IOException | InvalidConfigurationException ex) {
                plugin.getLogger().severe("Error: Unable to load signcommands.yml file.");
                plugin.getLogger().severe("Please make sure signcommands.yml is configured correctly.");
                if (!plugin.isDebug()) break block5;
                ex.printStackTrace();
            }
        }
        for (String sectionKey : yamlConfiguration.getKeys(false)) {
            List commands = yamlConfiguration.getStringList(sectionKey);
            if (commands.isEmpty()) {
                plugin.getLogger().warning("Sign command " + sectionKey + " has no commands! This may be a configuration error.");
            }
            this.signCommands.put(sectionKey, commands);
        }
    }

    public void cleanUp() {
        this.signCommands.clear();
    }

    public List<String> getCommands(String name) {
        return this.signCommands.get(name);
    }
}

