/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure;

import com.ryandw11.structure.CustomStructures;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class NpcHandler {
    private final Map<String, NpcInfo> npcInfoMap;

    public NpcHandler(File dataFolder, CustomStructures plugin) {
        YamlConfiguration yamlConfiguration;
        block6: {
            this.npcInfoMap = new HashMap<String, NpcInfo>();
            yamlConfiguration = new YamlConfiguration();
            File npcFile = new File(dataFolder, "npcs.yml");
            if (!npcFile.exists()) {
                return;
            }
            try {
                yamlConfiguration.load(new File(dataFolder, "npcs.yml"));
            }
            catch (Exception e) {
                plugin.getLogger().severe("There is a configuration error with: npcs.yml.");
                if (!plugin.isDebug()) break block6;
                e.printStackTrace();
            }
        }
        for (String npcKey : yamlConfiguration.getKeys(false)) {
            List commandsOnClick;
            ConfigurationSection section = yamlConfiguration.getConfigurationSection(npcKey);
            if (section == null) continue;
            NpcInfo npcInfo = new NpcInfo();
            npcInfo.name = this.getValueWithDefault(section, "name", "");
            npcInfo.skinUrl = this.getValueWithDefault(section, "skinUrl", null);
            npcInfo.movesAround = this.getValueWithDefault(section, "movesAround", false);
            npcInfo.looksAtPlayer = this.getValueWithDefault(section, "looksAtPlayer", false);
            npcInfo.isProtected = this.getValueWithDefault(section, "isProtected", false);
            npcInfo.commandsSequential = this.getValueWithDefault(section, "commandsSequential", false);
            npcInfo.entityType = this.getValueWithDefault(section, "entityType", "VILLAGER");
            List commandsOnCreate = section.getStringList("commandsOnCreate");
            if (!commandsOnCreate.isEmpty()) {
                npcInfo.commandsOnCreate = commandsOnCreate;
            }
            if (!(commandsOnClick = section.getStringList("commandsOnClick")).isEmpty()) {
                npcInfo.commandsOnClick = commandsOnClick;
            }
            this.npcInfoMap.put(npcKey, npcInfo);
        }
    }

    private <T> T getValueWithDefault(ConfigurationSection npc, String attributeName, T defaultValue) {
        return (T)(npc.contains(attributeName) ? npc.get(attributeName) : defaultValue);
    }

    public void cleanUp() {
        this.npcInfoMap.clear();
    }

    public NpcInfo getNPCByName(String name) {
        return this.npcInfoMap.get(name);
    }

    public static class NpcInfo {
        public String name = "";
        public String skinUrl = "";
        public boolean movesAround = false;
        public boolean looksAtPlayer = false;
        public boolean isProtected = false;
        public String entityType = "VILLAGER";
        public List<String> commandsOnCreate = new ArrayList<String>();
        public List<String> commandsOnClick = new ArrayList<String>();
        public boolean commandsSequential = false;
    }
}

