/*
 * Decompiled with CFR 0.152.
 */
package com.ryandw11.structure;

import com.ryandw11.structure.AddonHandler;
import com.ryandw11.structure.NpcHandler;
import com.ryandw11.structure.SignCommandsHandler;
import com.ryandw11.structure.api.structaddon.CustomStructureAddon;
import com.ryandw11.structure.bstats.bukkit.Metrics;
import com.ryandw11.structure.bstats.charts.AdvancedPie;
import com.ryandw11.structure.citizens.CitizensDisabled;
import com.ryandw11.structure.citizens.CitizensEnabled;
import com.ryandw11.structure.citizens.CitizensNpcHook;
import com.ryandw11.structure.commands.SCommand;
import com.ryandw11.structure.commands.SCommandTab;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks_1_13;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks_1_14;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks_1_15;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks_1_16;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks_1_17;
import com.ryandw11.structure.ignoreblocks.IgnoreBlocks_1_19;
import com.ryandw11.structure.listener.ChunkLoad;
import com.ryandw11.structure.listener.PlayerJoin;
import com.ryandw11.structure.loottables.LootTableHandler;
import com.ryandw11.structure.loottables.customitems.CustomItemManager;
import com.ryandw11.structure.mythicalmobs.MMDisabled;
import com.ryandw11.structure.mythicalmobs.MMEnabled;
import com.ryandw11.structure.mythicalmobs.MythicalMobHook;
import com.ryandw11.structure.schematic.StructureSignHandler;
import com.ryandw11.structure.structure.StructureHandler;
import com.ryandw11.structure.utils.CSUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomStructures
extends JavaPlugin {
    public static CustomStructures plugin;
    private final File lootTableFile = new File(this.getDataFolder() + "/lootTables/lootTable.yml");
    private final FileConfiguration lootTablesFC = YamlConfiguration.loadConfiguration((File)this.lootTableFile);
    private MythicalMobHook mythicalMobHook;
    private CitizensNpcHook citizensNpcHook;
    private SignCommandsHandler signCommandsHandler;
    private NpcHandler npcHandler;
    private StructureHandler structureHandler;
    private LootTableHandler lootTableHandler;
    private CustomItemManager customItemManager;
    private IgnoreBlocks blockIgnoreManager;
    private AddonHandler addonHandler;
    private StructureSignHandler structureSignHandler;
    private Metrics metrics;
    private boolean debugMode;
    public static boolean enabled;
    private boolean initialized = false;
    public static final int COMPILED_STRUCT_VER = 1;
    public static final int CONFIG_VERSION = 9;
    private static boolean papiEnabled;

    public void onEnable() {
        File f;
        enabled = true;
        plugin = this;
        this.loadManager();
        this.registerConfig();
        this.setupBlockIgnore();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("Placeholder API found, placeholders supported.");
            papiEnabled = true;
        } else {
            this.getLogger().info("PlaceholderAPI not found.");
        }
        if (this.getServer().getPluginManager().getPlugin("Citizens") != null) {
            this.citizensNpcHook = new CitizensEnabled(this);
            this.getLogger().info("Citizens detected! Activating plugin hook!");
        } else {
            this.citizensNpcHook = new CitizensDisabled();
        }
        if (this.getServer().getPluginManager().getPlugin("MythicMobs") != null) {
            this.mythicalMobHook = new MMEnabled();
            this.getLogger().info("MythicMobs detected! Activating plugin hook!");
        } else {
            this.mythicalMobHook = new MMDisabled();
        }
        this.loadFiles();
        this.debugMode = this.getConfig().getBoolean("debug");
        if (this.getConfig().getInt("configversion") < 9) {
            this.lootTableHandler = new LootTableHandler();
            this.updateConfig(this.getConfig().getInt("configversion"));
        }
        if (!(f = new File(this.getDataFolder() + File.separator + "schematics")).exists()) {
            this.getLogger().info("Loading the plugin for the first time.");
            this.getLogger().info("A demo structure will be added! Please make sure to test out this plugin in a test world!");
        }
        this.exportResource(new File(this.getDataFolder(), "schematics"), "demo.schem", "schematics/");
        this.exportResource(new File(this.getDataFolder(), "structures"), "demo.yml", "structures/");
        this.exportResource(this.getDataFolder(), "npcs.yml", "");
        this.exportResource(this.getDataFolder(), "signcommands.yml", "");
        this.customItemManager = new CustomItemManager(this, new File(this.getDataFolder() + File.separator + "items" + File.separator + "customitems.yml"), new File(this.getDataFolder() + File.separator + "items"));
        this.signCommandsHandler = new SignCommandsHandler(this.getDataFolder(), this);
        this.npcHandler = new NpcHandler(this.getDataFolder(), plugin);
        this.lootTableHandler = new LootTableHandler();
        this.addonHandler = new AddonHandler();
        this.structureSignHandler = new StructureSignHandler();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, this::initialize, 30L);
        if (this.getConfig().getBoolean("bstats")) {
            this.metrics = new Metrics(this, 7056);
            this.getLogger().info("Bstat metrics for this plugin is enabled. Disable it in the config if you do not want it on.");
        } else {
            this.getLogger().info("Bstat metrics is disabled for this plugin.");
        }
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (this.getConfig().getInt("configversion") != 9) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[CustomStructures] Cannot enable plugin, your config version is outdated. Check the above for errors that may have occurred during the auto-update process." + ChatColor.RESET);
            return;
        }
        this.structureHandler = new StructureHandler(this.getConfig().getStringList("Structures"), this);
        this.getLogger().info("The plugin has been fully enabled with " + this.structureHandler.getStructures().size() + " structures.");
        this.getLogger().info(this.addonHandler.getCustomStructureAddons().size() + " addons were found.");
        if (this.metrics != null) {
            this.metrics.addCustomChart(new AdvancedPie("used_addons", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                for (CustomStructureAddon addon : this.addonHandler.getCustomStructureAddons()) {
                    valueMap.put(addon.getName(), 1);
                }
                return valueMap;
            }));
        }
        this.initialized = true;
    }

    public static String replacePAPIPlaceholders(String text) {
        if (papiEnabled) {
            return PlaceholderAPI.setPlaceholders(null, (String)text);
        }
        return text;
    }

    private void exportResource(File targetDirectory, String filename, String resourcePath) {
        File targetFile;
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        if (!(targetFile = new File(targetDirectory, filename)).exists()) {
            this.saveResource(resourcePath + filename, false);
        }
    }

    public void onDisable() {
        if (this.structureHandler == null) {
            this.getLogger().severe("ERROR: The Structure Handler was never initialized during setup.");
            return;
        }
        this.structureHandler.cleanup();
        this.npcHandler.cleanUp();
        this.signCommandsHandler.cleanUp();
    }

    private void setupBlockIgnore() {
        String version;
        try {
            version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.getLogger().severe("Unable to detect Minecraft version! The plugin will now be disabled.");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        switch (version) {
            case "v1_18_R2": 
            case "v1_18_R1": 
            case "v1_17_R1": {
                this.blockIgnoreManager = new IgnoreBlocks_1_17();
                break;
            }
            case "v1_16_R3": 
            case "v1_16_R2": 
            case "v1_16_R1": {
                this.blockIgnoreManager = new IgnoreBlocks_1_16();
                break;
            }
            case "v1_15_R1": {
                this.blockIgnoreManager = new IgnoreBlocks_1_15();
                break;
            }
            case "v1_14_R1": {
                this.blockIgnoreManager = new IgnoreBlocks_1_14();
                break;
            }
            case "v1_13_R1": {
                this.blockIgnoreManager = new IgnoreBlocks_1_13();
                break;
            }
            default: {
                this.blockIgnoreManager = new IgnoreBlocks_1_19();
            }
        }
    }

    public IgnoreBlocks getBlockIgnoreManager() {
        return this.blockIgnoreManager;
    }

    public StructureHandler getStructureHandler() {
        return this.structureHandler;
    }

    public LootTableHandler getLootTableHandler() {
        return this.lootTableHandler;
    }

    public void reloadHandlers() {
        this.signCommandsHandler.cleanUp();
        this.signCommandsHandler = new SignCommandsHandler(this.getDataFolder(), this);
        this.npcHandler.cleanUp();
        this.npcHandler = new NpcHandler(this.getDataFolder(), plugin);
        this.structureHandler.cleanup();
        this.structureHandler = new StructureHandler(this.getConfig().getStringList("Structures"), this);
        this.lootTableHandler = new LootTableHandler();
        this.addonHandler.handlePluginReload();
    }

    public static CustomStructures getInstance() {
        return plugin;
    }

    private void loadManager() {
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new ChunkLoad(), (Plugin)this);
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PlayerJoin(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("customstructure")).setExecutor((CommandExecutor)new SCommand(this));
        Objects.requireNonNull(this.getCommand("customstructure")).setTabCompleter((TabCompleter)new SCommandTab(this));
    }

    private void registerConfig() {
        this.saveDefaultConfig();
    }

    public void loadFiles() {
        if (this.lootTableFile.exists()) {
            try {
                this.lootTablesFC.load(this.lootTableFile);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            this.saveResource("lootTables/lootTable.yml", false);
        }
    }

    private void updateConfig(int ver) {
        ConfigurationSection section;
        YamlConfiguration structConfig;
        YamlConfiguration fileConfiguration;
        File backupDirectory;
        File structDir;
        this.getLogger().info("An older version of the plugin has been detected!");
        this.getLogger().info("Automatically converting old format into the new one.");
        if (ver < 5) {
            this.getLogger().severe("Error: Your config is too old for the plugin to update.");
            this.getLogger().severe("Please use custom structures 1.5.4 or older before updating to the latest version.");
            this.getLogger().severe("The plugin will now disable itself.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (ver < 7) {
            this.getLogger().severe("Error: Your config is too old for the plugin to update.");
            this.getLogger().severe("Please consult the plugin wiki to see what version to use to update your configuration files.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (ver < 8) {
            this.getLogger().info("Updating all structure config files...");
            structDir = new File(this.getDataFolder(), "structures");
            if (!structDir.exists() && !structDir.isDirectory()) {
                this.getLogger().severe("An error occurred when trying to update the structure format: Unable to find structure directory! Does it exist?");
                return;
            }
            backupDirectory = new File(this.getDataFolder(), "backup");
            File backupdata = new File(backupDirectory, ".backups");
            if (!backupDirectory.exists() && !backupDirectory.mkdir()) {
                this.getLogger().severe("Error: Unable to create backup directory!");
                return;
            }
            if (!backupdata.exists()) {
                try {
                    backupdata.createNewFile();
                }
                catch (IOException ex) {
                    this.getLogger().severe("Error: Unable to create backup file.");
                    return;
                }
            }
            if ((fileConfiguration = YamlConfiguration.loadConfiguration((File)backupdata)).contains("backupVer")) {
                int backupVer = fileConfiguration.getInt("backupVer");
                if (backupVer != 8) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "===============[CUSTOM STRUCTURES UPDATE]===============" + ChatColor.RESET);
                    this.getLogger().severe("Unable to update plugin! Backup data is outdated!");
                    this.getLogger().severe("Please delete the backup folder in the CustomStructures directory before continuing!");
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "===============[CUSTOM STRUCTURES UPDATE]===============" + ChatColor.RESET);
                    return;
                }
            } else {
                fileConfiguration.set("backupVer", (Object)8);
                try {
                    fileConfiguration.save(backupdata);
                }
                catch (IOException ex) {
                    this.getLogger().severe("A critical error has occurred while backing up the plugin data.");
                    return;
                }
            }
            ArrayList<String> updatedStructures = new ArrayList<String>(fileConfiguration.getStringList("UpdatedStructures"));
            if (!updatedStructures.isEmpty()) {
                this.getLogger().info("Previous update attempt detected.");
                this.getLogger().info(String.format("%s completed structure updates were found. If this is your first time updating to this version of CustomStructures, then please delete the backup directory and restart the server.", updatedStructures.size()));
                this.getLogger().info("The server will now wait 5 seconds to give you a chance to stop the server before the update automatically continues. Press ctrl+c to cancel running the server.");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    this.getLogger().info("Server shutdown detected. Stopping update.");
                    return;
                }
            }
            this.createBackupForFile("config.yml", "/backup/config.yml.backup");
            for (String s : this.getConfig().getStringList("Structures")) {
                if (updatedStructures.contains(s)) continue;
                try {
                    this.createBackupForFile("/structures/" + s + ".yml", "/backup/" + s + ".yml.backup");
                    structConfig = YamlConfiguration.loadConfiguration((File)new File(structDir, s + ".yml"));
                    if (!structConfig.contains("SubSchematics.Schematics")) continue;
                    for (String struct : structConfig.getConfigurationSection("SubSchematics.Schematics").getKeys(false)) {
                        section = structConfig.getConfigurationSection("SubSchematics.Schematics." + struct);
                        if (!section.contains("file")) {
                            this.getLogger().severe(String.format("An error has occurred when attempting to update structure %s!", s));
                            this.getLogger().severe(String.format("Cannot find 'file' option on %s when update the SubSchematics property!", struct));
                            this.getLogger().severe("After fixing the error, restart the server for the plugin to continue updating from where it left off.");
                            return;
                        }
                        section.set("File", (Object)section.getString("file"));
                        section.set("file", null);
                    }
                    try {
                        structConfig.save(new File(structDir, s + ".yml"));
                    }
                    catch (IOException ex) {
                        this.getLogger().info(String.format("An error has occurred when updating %s!", s));
                        this.getLogger().severe("Error: unable to save updated structure file!");
                        return;
                    }
                    this.getLogger().info(String.format("Successfully updated the structure: %s!", s));
                    updatedStructures.add(s);
                    fileConfiguration.set("UpdatedStructures", updatedStructures);
                    fileConfiguration.save(backupdata);
                }
                catch (Exception ex) {
                    this.getLogger().severe(String.format("An error has occurred when updating %s:", s));
                    ex.printStackTrace();
                    this.getLogger().severe("After fixing the error, restart the server for the plugin to continue updating from where it left off.");
                    return;
                }
            }
            this.getConfig().set("configversion", (Object)8);
            this.saveConfig();
            this.getLogger().info("Successfully updated all structure files to the latest version (8).");
            this.getLogger().info("Please delete the backup folder that was created in the CustomStructures directory after you confirm everything was updated correctly.");
        }
        if (ver < 9) {
            File lootTableFolder;
            File[] lootTableFiles;
            this.getLogger().info("Updating all structure config files...");
            structDir = new File(this.getDataFolder(), "structures");
            if (!structDir.exists() && !structDir.isDirectory()) {
                this.getLogger().severe("An error occurred when trying to update the structure format: Unable to find structure directory! Does it exist?");
                return;
            }
            backupDirectory = new File(this.getDataFolder(), "backup");
            File backupData = new File(backupDirectory, ".backups");
            if (!backupDirectory.exists() && !backupDirectory.mkdir()) {
                this.getLogger().severe("Error: Unable to create backup directory!");
                return;
            }
            if (!backupData.exists()) {
                try {
                    backupData.createNewFile();
                }
                catch (IOException ex) {
                    this.getLogger().severe("Error: Unable to create backup file.");
                    return;
                }
            }
            if ((fileConfiguration = YamlConfiguration.loadConfiguration((File)backupData)).contains("backupVer")) {
                int backupVer = fileConfiguration.getInt("backupVer");
                if (backupVer != 9) {
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "===============[CUSTOM STRUCTURES UPDATE]===============" + ChatColor.RESET);
                    this.getLogger().severe("Unable to update plugin! Backup data is outdated!");
                    this.getLogger().severe("Please delete the backup folder in the CustomStructures directory before continuing!");
                    Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "===============[CUSTOM STRUCTURES UPDATE]===============" + ChatColor.RESET);
                    return;
                }
            } else {
                fileConfiguration.set("backupVer", (Object)9);
                try {
                    fileConfiguration.save(backupData);
                }
                catch (IOException ex) {
                    this.getLogger().severe("A critical error has occurred while backing up the plugin data.");
                    return;
                }
            }
            if (!fileConfiguration.getBoolean("finishedStructureUpdates", false)) {
                ArrayList<String> updatedStructures = new ArrayList<String>(fileConfiguration.getStringList("UpdatedStructures"));
                if (!updatedStructures.isEmpty()) {
                    this.getLogger().info("Previous update attempt detected.");
                    this.getLogger().info(String.format("%s completed structure updates were found. If this is your first time updating to this version of CustomStructures, then please delete the backup directory and restart the server.", updatedStructures.size()));
                    this.getLogger().info("The server will now wait 5 seconds to give you a chance to stop the server before the update automatically continues. Press ctrl+c to cancel running the server.");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ex) {
                        this.getLogger().info("Server shutdown detected. Stopping update.");
                        return;
                    }
                }
                this.createBackupForFile("config.yml", "/backup/config.yml.backup");
                for (String s : this.getConfig().getStringList("Structures")) {
                    if (updatedStructures.contains(s)) continue;
                    try {
                        this.createBackupForFile("/structures/" + s + ".yml", "/backup/" + s + ".yml.backup");
                        structConfig = YamlConfiguration.loadConfiguration((File)new File(structDir, s + ".yml"));
                        CSUtils.renameConfigString((ConfigurationSection)structConfig, "schematic", "Schematic");
                        CSUtils.renameConfigString((ConfigurationSection)structConfig, "compiled_schematic", "CompiledSchematic");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "Chance.Number", "Probability.Numerator");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "Chance.OutOf", "Probability.Denominator");
                        structConfig.set("Chance", null);
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLocation.spawn_distance.x", "StructureLocation.SpawnDistance.x");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLocation.spawn_distance.z", "StructureLocation.SpawnDistance.z");
                        structConfig.set("StructureLocation.spawn_distance", null);
                        CSUtils.renameConfigBoolean((ConfigurationSection)structConfig, "StructureProperties.randomRotation", "StructureProperties.RandomRotation");
                        CSUtils.renameConfigBoolean((ConfigurationSection)structConfig, "StructureProperties.ignorePlants", "StructureProperties.IgnorePlants");
                        CSUtils.renameConfigBoolean((ConfigurationSection)structConfig, "StructureProperties.spawnInWater", "StructureProperties.SpawnInWater");
                        CSUtils.renameConfigBoolean((ConfigurationSection)structConfig, "StructureProperties.spawnInLavaLakes", "StructureProperties.SpawnInLavaLakes");
                        CSUtils.renameConfigBoolean((ConfigurationSection)structConfig, "StructureProperties.spawnInVoid", "StructureProperties.SpawnInVoid");
                        CSUtils.renameConfigBoolean((ConfigurationSection)structConfig, "StructureProperties.ignoreWater", "StructureProperties.IgnoreWater");
                        CSUtils.renameConfigStringList((ConfigurationSection)structConfig, "StructureLimitations.whitelistSpawnBlocks", "StructureLimitations.WhitelistSpawnBlocks");
                        CSUtils.renameConfigStringList((ConfigurationSection)structConfig, "StructureLimitations.blacklistSpawnBlocks", "StructureLimitations.BlacklistSpawnBlocks");
                        CSUtils.renameConfigString((ConfigurationSection)structConfig, "StructureLimitations.BlockLevelLimit.mode", "StructureLimitations.BlockLevelLimit.Mode");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.BlockLevelLimit.cornerOne.x", "StructureLimitations.BlockLevelLimit.CornerOne.x");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.BlockLevelLimit.cornerOne.z", "StructureLimitations.BlockLevelLimit.CornerOne.z");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.BlockLevelLimit.cornerTwo.x", "StructureLimitations.BlockLevelLimit.CornerTwo.x");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.BlockLevelLimit.cornerTwo.z", "StructureLimitations.BlockLevelLimit.CornerTwo.z");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.BlockLevelLimit.error", "StructureLimitations.BlockLevelLimit.Error");
                        structConfig.set("StructureLimitations.BlockLevelLimit.cornerOne", null);
                        structConfig.set("StructureLimitations.BlockLevelLimit.cornerTwo", null);
                        CSUtils.renameStringConfigurationSection((ConfigurationSection)structConfig, "StructureLimitations.replacement_blocks", "StructureLimitations.ReplaceBlocks");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.replacement_blocks_delay", "StructureLimitations.ReplaceBlockDelay");
                        CSUtils.renameConfigInteger((ConfigurationSection)structConfig, "StructureLimitations.iterationLimit", "StructureLimitations.IterationLimit");
                        if (structConfig.contains("SubSchematics")) {
                            if (!structConfig.getBoolean("SubSchematics.Enabled", true) || structConfig.getConfigurationSection("SubSchematics.Schematics") == null) {
                                structConfig.set("SubSchematics", null);
                            } else {
                                structConfig.set("SubSchematics.Enabled", null);
                                for (String key : structConfig.getConfigurationSection("SubSchematics.Schematics").getKeys(false)) {
                                    section = structConfig.getConfigurationSection("SubSchematics.Schematics." + key);
                                    structConfig.set("SubSchematics." + key, (Object)section);
                                }
                                structConfig.set("SubSchematics.Schematics", null);
                            }
                        }
                        if (structConfig.contains("Masks")) {
                            structConfig.set("SourceMask.Enabled", (Object)structConfig.getBoolean("Masks.enabled"));
                            structConfig.set("SourceMask.UnionType", (Object)structConfig.getString("Masks.union_type"));
                            structConfig.set("SourceMask.BlockTypeMask", (Object)structConfig.getStringList("Masks.BlockTypeMask"));
                            structConfig.set("SourceMask.NegatedBlockMask", (Object)structConfig.getStringList("Masks.NegatedBlockMask"));
                            structConfig.set("Masks", null);
                        }
                        try {
                            structConfig.save(new File(structDir, s + ".yml"));
                        }
                        catch (IOException ex) {
                            this.getLogger().info(String.format("An error has occurred when updating %s!", s));
                            this.getLogger().severe("Error: unable to save updated structure file!");
                            return;
                        }
                        this.getLogger().info(String.format("Successfully updated the structure: %s!", s));
                        updatedStructures.add(s);
                        fileConfiguration.set("UpdatedStructures", updatedStructures);
                        fileConfiguration.save(backupData);
                    }
                    catch (Exception ex) {
                        this.getLogger().severe(String.format("An error has occurred when updating %s.", s));
                        ex.printStackTrace();
                        this.getLogger().severe("After fixing the error, restart the server for the plugin to continue updating from where it left off.");
                        return;
                    }
                }
                fileConfiguration.set("finishedStructureUpdates", (Object)true);
                try {
                    fileConfiguration.save(backupData);
                }
                catch (IOException ex) {
                    this.getLogger().severe("An error has occurred when trying to save the backup file!");
                    ex.printStackTrace();
                    this.getLogger().severe("After fixing the error, restart the server for the plugin to continue updating from where it left off.");
                }
            }
            if ((lootTableFiles = (lootTableFolder = new File(this.getDataFolder(), "lootTables")).listFiles()) != null) {
                ArrayList<String> updatedLootTables = new ArrayList<String>(fileConfiguration.getStringList("UpdatedLootTables"));
                for (File file : lootTableFiles) {
                    if (!file.getName().endsWith(".yml")) continue;
                    String lootTableName = file.getName().replace(".yml", "");
                    try {
                        if (updatedLootTables.contains(lootTableName)) continue;
                        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
                        for (String key : configuration.getConfigurationSection("Items").getKeys(false)) {
                            ConfigurationSection section2 = configuration.getConfigurationSection("Items." + key);
                            String type = section2.getString("Type", "AIR");
                            if (type.equalsIgnoreCase("CUSTOM")) {
                                section2.set("Type", (Object)"CUSTOM");
                                continue;
                            }
                            section2.set("Material", (Object)type);
                            section2.set("Type", (Object)"STANDARD");
                        }
                        configuration.save(file);
                        this.getLogger().info(String.format("Successfully updated the loot table: %s!", lootTableName));
                        updatedLootTables.add(lootTableName);
                        fileConfiguration.set("UpdatedLootTables", updatedLootTables);
                        fileConfiguration.save(backupData);
                    }
                    catch (Exception ex) {
                        this.getLogger().severe(String.format("An error has occurred when updating the loot table %s.", lootTableName));
                        ex.printStackTrace();
                        this.getLogger().severe("After fixing the error, restart the server for the plugin to continue updating from where it left off.");
                        return;
                    }
                }
            }
            this.getConfig().set("configversion", (Object)9);
            this.saveConfig();
            this.getLogger().info("Successfully updated all structure files to the latest version (9).");
            this.getLogger().info("Please delete the backup folder that was created in the CustomStructures directory after you confirm everything was updated correctly.");
        }
    }

    private boolean createBackupForFile(String file, String backupFile) {
        File config = new File(this.getDataFolder(), file);
        File configBackup = new File(this.getDataFolder(), backupFile);
        try {
            configBackup.createNewFile();
            FileUtils.copyFile(config, configBackup);
        }
        catch (IOException ex) {
            this.getLogger().severe("A critical error was encountered when attempting to update plugin configuration files!");
            this.getLogger().severe("Unable to create a backup for " + file);
            return false;
        }
        return true;
    }

    public boolean isDebug() {
        return this.debugMode;
    }

    public CustomItemManager getCustomItemManager() {
        return this.customItemManager;
    }

    public SignCommandsHandler getSignCommandsHandler() {
        return this.signCommandsHandler;
    }

    public NpcHandler getNpcHandler() {
        return this.npcHandler;
    }

    public AddonHandler getAddonHandler() {
        return this.addonHandler;
    }

    public StructureSignHandler getStructureSignHandler() {
        return this.structureSignHandler;
    }

    public MythicalMobHook getMythicalMobHook() {
        return this.mythicalMobHook;
    }

    public CitizensNpcHook getCitizensNpcHook() {
        return this.citizensNpcHook;
    }

    static {
        papiEnabled = false;
    }
}

