/*
 * Decompiled with CFR 0.152.
 */
package me.yorick.customshopkeepers;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.yorick.customshopkeepers.Main;
import net.minecraft.server.v1_12_R1.DataWatcherRegistry;
import net.minecraft.server.v1_12_R1.Entity;
import net.minecraft.server.v1_12_R1.EntityHuman;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.MinecraftServer;
import net.minecraft.server.v1_12_R1.Packet;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_12_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_12_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_12_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_12_R1.PlayerConnection;
import net.minecraft.server.v1_12_R1.PlayerInteractManager;
import net.minecraft.server.v1_12_R1.World;
import net.minecraft.server.v1_12_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;
import org.bukkit.craftbukkit.v1_12_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NPCManager {
    private static List<EntityPlayer> NPC = new ArrayList<EntityPlayer>();

    public static void createNPC(Player player, String skin, String npcName) {
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer world = ((CraftWorld)Bukkit.getWorld((String)player.getWorld().getName())).getHandle();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), ChatColor.translateAlternateColorCodes((char)'&', (String)npcName));
        EntityPlayer npc = new EntityPlayer(server, world, gameProfile, new PlayerInteractManager((World)world));
        npc.setLocation(player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ(), player.getLocation().getYaw(), player.getLocation().getPitch());
        String[] name = NPCManager.getSkin(player, skin);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", name[0], name[1]));
        NPCManager.addNPCPacket(npc);
        NPC.add(npc);
        Main.getData().set("data." + npcName + ".id", (Object)npc.getId());
        Main.getData().set("data." + npcName + ".x", (Object)player.getLocation().getX());
        Main.getData().set("data." + npcName + ".y", (Object)player.getLocation().getY());
        Main.getData().set("data." + npcName + ".z", (Object)player.getLocation().getZ());
        Main.getData().set("data." + npcName + ".yaw", (Object)Float.valueOf(player.getLocation().getYaw()));
        Main.getData().set("data." + npcName + ".pitch", (Object)Float.valueOf(player.getLocation().getPitch()));
        Main.getData().set("data." + npcName + ".world", (Object)player.getLocation().getWorld().getName());
        Main.getData().set("data." + npcName + ".name", (Object)npcName);
        Main.getData().set("data." + npcName + ".texture", (Object)name[0]);
        Main.getData().set("data." + npcName + ".signature", (Object)name[1]);
        Main.getData().createSection("inventories." + npcName + ".trades");
        Main.saveData();
    }

    public static void loadNPC(Location location, GameProfile profile) {
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        WorldServer world = ((CraftWorld)location.getWorld()).getHandle();
        GameProfile gameProfile = profile;
        EntityPlayer npc = new EntityPlayer(server, world, gameProfile, new PlayerInteractManager((World)world));
        npc.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        NPCManager.addNPCPacket(npc);
        NPC.add(npc);
    }

    public static void removeNPC(Player player, EntityPlayer npc) {
        PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
        connection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{npc.getId()}));
    }

    private static String[] getSkin(Player player, String name) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
            InputStreamReader reader = new InputStreamReader(url.openStream());
            String uuid = new JsonParser().parse((Reader)reader).getAsJsonObject().get("id").getAsString();
            URL url2 = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            InputStreamReader reader2 = new InputStreamReader(url2.openStream());
            JsonObject property = new JsonParser().parse((Reader)reader2).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            String texture = property.get("value").getAsString();
            String signature = property.get("signature").getAsString();
            return new String[]{texture, signature};
        }
        catch (Exception e) {
            EntityPlayer p = ((CraftPlayer)player).getHandle();
            GameProfile profile = p.getProfile();
            Property property = (Property)profile.getProperties().get((Object)"textures").iterator().next();
            String texture = property.getValue();
            String signature = property.getSignature();
            return new String[]{texture, signature};
        }
    }

    public static void addNPCPacket(final EntityPlayer npc) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            final PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
            connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{npc}));
            connection.sendPacket((Packet)new PacketPlayOutNamedEntitySpawn((EntityHuman)npc));
            connection.sendPacket((Packet)new PacketPlayOutEntityHeadRotation((Entity)npc, (byte)(npc.yaw * 256.0f / 360.0f)));
            npc.getDataWatcher().set(DataWatcherRegistry.a.a(13), (Object)127);
            connection.sendPacket((Packet)new PacketPlayOutEntityMetadata(npc.getId(), npc.getDataWatcher(), true));
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(Main.class), new Runnable(){

                @Override
                public void run() {
                    connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{npc}));
                }
            }, 5L);
        }
    }

    public static void destoryNPC(int npcID) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
            connection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{npcID}));
        }
    }

    public static void addJoinPacket(Player player) {
        for (EntityPlayer npc : NPC) {
            PlayerConnection connection = ((CraftPlayer)player).getHandle().playerConnection;
            connection.sendPacket((Packet)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{npc}));
            connection.sendPacket((Packet)new PacketPlayOutNamedEntitySpawn((EntityHuman)npc));
            connection.sendPacket((Packet)new PacketPlayOutEntityHeadRotation((Entity)npc, (byte)(npc.yaw * 256.0f / 360.0f)));
        }
    }

    public static List<EntityPlayer> getNPCs() {
        return NPC;
    }
}

