/*
 * Decompiled with CFR 0.152.
 */
package me.yorick.customshopkeepers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.UUID;
import me.yorick.customshopkeepers.ClickNPC;
import me.yorick.customshopkeepers.DataManager;
import me.yorick.customshopkeepers.JoinEvent;
import me.yorick.customshopkeepers.NPCManager;
import me.yorick.customshopkeepers.PacketReader;
import me.yorick.customshopkeepers.Trader;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    public static DataManager data;

    public void onEnable() {
        data = new DataManager(this);
        this.getCommand("traders").setExecutor((CommandExecutor)new Trader());
        Bukkit.getPluginManager().registerEvents((Listener)new JoinEvent(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ClickNPC(), (Plugin)this);
        if (!Bukkit.getOnlinePlayers().isEmpty()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                PacketReader reader = new PacketReader();
                reader.inject(player);
            }
        }
        if (data.getConfig().contains("data")) {
            Main.loadNPC();
        }
        this.loadConfig();
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        console.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&6&lC&e&lustom&6&lS&e&lhop&6&lK&e&leepers&7] &eThis plugin is successfully Enabled!"));
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            for (EntityPlayer npc : NPCManager.getNPCs()) {
                NPCManager.removeNPC(player, npc);
            }
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketReader reader = new PacketReader();
            reader.unInject(player);
        }
        ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();
        console.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7[&6&lC&e&lustom&6&lS&e&lhop&6&lK&e&leepers&7] &eThis plugin is successfully Disabled!"));
    }

    public void loadConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public static FileConfiguration getData() {
        return data.getConfig();
    }

    public static void saveData() {
        data.saveConfig();
    }

    public static void loadNPC() {
        FileConfiguration file = data.getConfig();
        data.getConfig().getConfigurationSection("data").getKeys(false).forEach(npc -> {
            Location location = new Location(Bukkit.getWorld((String)file.getString("data." + npc + ".world")), file.getDouble("data." + npc + ".x"), file.getDouble("data." + npc + ".y"), file.getDouble("data." + npc + ".z"));
            location.setPitch((float)file.getDouble("data." + npc + ".pitch"));
            location.setYaw((float)file.getDouble("data." + npc + ".yaw"));
            String name = file.getString("data." + npc + ".name");
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", file.getString("data." + npc + ".texture"), file.getString("data." + npc + ".signature")));
            NPCManager.loadNPC(location, gameProfile);
        });
    }
}

