/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.updater;

import com.rictacius.customShop.Main;
import com.rictacius.customShop.Util;
import com.rictacius.customShop.updater.UpdaterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import org.bukkit.craftbukkit.libs.org.apache.commons.io.FileUtils;

public class Updater {
    private static final String HOST = "http://victorolaitan.xyz/rictacius/download";
    private String newVersionName;
    private boolean devBuild;

    public boolean isNewVersionAvailable() throws UpdaterException {
        this.newVersionName = null;
        String latestVersionInfo = this.fetchCustomShopLatestVersionInfo();
        if (latestVersionInfo == null) {
            return false;
        }
        this.newVersionName = this.getNewVersionName(latestVersionInfo);
        return this.newVersionName != null;
    }

    private String fetchCustomShopLatestVersionInfo() throws UpdaterException {
        try {
            String line;
            URL url = new URL(HOST);
            URLConnection con = url.openConnection();
            InputStream is = con.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("CustomShop")) continue;
                return line;
            }
        }
        catch (IOException e) {
            throw new UpdaterException("Failed to fetch update info", e);
        }
        return null;
    }

    private String getNewVersionName(String latestVersionInfo) {
        String currentVersion = Main.plugin.getDescription().getVersion();
        String fetchedVersion = latestVersionInfo.split(":")[1];
        if (fetchedVersion.contains(".")) {
            String[] currentVersionParts = currentVersion.split("\\.");
            String[] fetchedVersionParts = fetchedVersion.split("\\.");
            if (fetchedVersionParts.length != currentVersionParts.length) {
                return fetchedVersion;
            }
            for (int i = 0; i < fetchedVersionParts.length; ++i) {
                int currentVersionPartialNumber;
                int fetchedVersionPartialNumber = Integer.parseInt(fetchedVersionParts[i]);
                boolean bl = this.devBuild = fetchedVersionPartialNumber < (currentVersionPartialNumber = Integer.parseInt(currentVersionParts[i]));
                if (this.devBuild) {
                    return null;
                }
                if (fetchedVersionPartialNumber <= currentVersionPartialNumber) continue;
                return fetchedVersion;
            }
        } else if (!fetchedVersion.equals(currentVersion)) {
            return fetchedVersion;
        }
        return null;
    }

    public void downloadNewVersion() throws UpdaterException {
        if (this.newVersionName == null) {
            throw new UpdaterException("There is no new version to download!");
        }
        try {
            String urlStr = "http://victorolaitan.xyz/rictacius/download/CustomShop/" + this.newVersionName + "/CustomShop.jar";
            URL website = new URL(urlStr);
            String pathToDownloadTo = "plugins/CustomShop-" + this.newVersionName + ".jar";
            FileUtils.copyURLToFile((URL)website, (File)new File(pathToDownloadTo), (int)30000, (int)30000);
            Util.consoleLog("Successfully downloaded update JAR to " + pathToDownloadTo);
        }
        catch (IOException e) {
            throw new UpdaterException("Failed to download update");
        }
    }

    public String getNewVersionName() {
        return this.newVersionName;
    }

    public boolean isDevBuild() {
        return this.devBuild;
    }
}

