/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.shop;

import com.rictacius.customShop.Main;
import com.rictacius.customShop.PermCheck;
import com.rictacius.customShop.config.ItemConfig;
import com.rictacius.customShop.config.ShopConfig;
import com.rictacius.customShop.config.ShopsConfig;
import com.rictacius.customShop.shop.Shop;
import de.tr7zw.nbtapi.NBTItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Shops
implements Listener {
    private Shop mainMenu;
    private Map<String, Shop> shops = new HashMap<String, Shop>();
    private Set<UUID> playersViewingAShop = new HashSet<UUID>();
    private Map<Material, ItemConfig> materialItemConfigMap = new HashMap<Material, ItemConfig>();

    public Shops() {
        this.loadShops();
    }

    public void loadShops() {
        ShopsConfig shopsConfig = Main.getShopsConfig();
        List<ShopConfig> shopConfigs = shopsConfig.getShopConfigs();
        List<Shop> shops = shopConfigs.stream().map(Shop::new).collect(Collectors.toList());
        this.mainMenu = new Shop(shops);
        this.shops.clear();
        this.materialItemConfigMap.clear();
        shops.forEach(shop -> this.shops.put(shop.getConfig().getName(), (Shop)shop));
        this.shops.put(null, this.mainMenu);
        for (Shop shop2 : shops) {
            for (ItemConfig itemConfig : shop2.getConfig().getItems()) {
                this.materialItemConfigMap.put(itemConfig.getMaterial(), itemConfig);
            }
        }
    }

    public Shop getMainMenu() {
        return this.mainMenu;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        if (event.getClickedInventory() == null || !event.getView().getTitle().equals(Shop.getInventoryName())) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)clicker;
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        NBTItem nbtItem = new NBTItem(item);
        String shopName = nbtItem.getString("shop");
        if (shopName == null || shopName.equals("")) {
            return;
        }
        Shop shop = this.shops.get(shopName);
        String requiredPermissionForShop = shop.getConfig().getRequiredPermission();
        if (requiredPermissionForShop != null && !PermCheck.hasAccessPerm(player, requiredPermissionForShop)) {
            player.sendMessage(ChatColor.RED + "You may not access this shop! Contact the server administrator for more info");
        }
        if (nbtItem.getBoolean("is-shop").booleanValue()) {
            player.openInventory(shop.getInventory());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, () -> this.playersViewingAShop.add(player.getUniqueId()), 2L);
            return;
        }
        shop.onClick(event, nbtItem);
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        HumanEntity entity = event.getPlayer();
        if (!(entity instanceof Player)) {
            return;
        }
        if (!event.getView().getTitle().equals(Shop.getInventoryName())) {
            return;
        }
        Player player = (Player)entity;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.plugin, () -> {
            if (this.playersViewingAShop.contains(player.getUniqueId())) {
                player.openInventory(this.mainMenu.getInventory());
                this.playersViewingAShop.remove(player.getUniqueId());
            }
        }, 2L);
    }

    @Nullable
    ItemConfig getConfigForMaterial(Material material) {
        return this.materialItemConfigMap.get(material);
    }
}

