/*
 * Decompiled with CFR 0.152.
 */
package com.rictacius.customShop.shop;

import com.rictacius.customShop.Main;
import com.rictacius.customShop.config.ItemConfig;
import com.rictacius.customShop.config.PluginConfig;
import com.rictacius.customShop.config.ShopConfig;
import de.tr7zw.nbtapi.NBTItem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

public class Shop {
    private static final String NBT_ITEM_INDEX_KEY = "item-index";
    private static final String NBT_BUY_KEY = "buy";
    private static final String NBT_SELL_KEY = "sell";
    static final String NBT_SHOP_KEY = "shop";
    static final String NBT_IS_SHOP_KEY = "is-shop";
    private ShopConfig config;
    private final Inventory inventory;
    private ItemStack logo;

    Shop(ShopConfig config) {
        PluginConfig pluginConfig = Main.getPluginConfig();
        this.config = config;
        List<ItemConfig> itemConfigs = config.getItems();
        this.inventory = this.createInventory(itemConfigs.size());
        for (int itemSlot = 0; itemSlot < itemConfigs.size(); ++itemSlot) {
            ItemConfig itemConfig = itemConfigs.get(itemSlot);
            ItemStack item = this.createItemForInventory(pluginConfig, config.getName(), itemSlot, itemConfig);
            this.inventory.setItem(itemSlot, item);
        }
        this.logo = this.createLogoFromInventory(this.inventory, config);
    }

    Shop(List<Shop> childShops) {
        this.inventory = this.createInventory(childShops.size());
        for (int itemSlot = 0; itemSlot < childShops.size(); ++itemSlot) {
            Shop childShop = childShops.get(itemSlot);
            ItemStack logo = childShop.getLogo();
            this.inventory.setItem(itemSlot, logo);
        }
    }

    static String getInventoryName() {
        PluginConfig pluginConfig = Main.getPluginConfig();
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)pluginConfig.getShopInventoryTitle());
    }

    static String replaceAmountCurrencyPricePlaceholders(String original, Integer amount, Double price) {
        original = ChatColor.translateAlternateColorCodes((char)'&', (String)original);
        original = original.replaceAll("<amount>", "" + amount).replaceAll("<price>", "" + price).replaceAll("<currency>", Matcher.quoteReplacement(Main.getPluginConfig().getCurrency()));
        return original;
    }

    private Inventory createInventory(int numSlots) {
        int rowCount = numSlots / 9 + (numSlots % 9 > 0 ? 1 : 0);
        return Bukkit.createInventory(null, (int)(rowCount * 9), (String)Shop.getInventoryName());
    }

    private ItemStack createItemForInventory(PluginConfig pluginConfig, String shopName, int itemIndex, ItemConfig itemConfig) {
        double stackPrice;
        ItemStack item = new ItemStack(itemConfig.getMaterial(), 1);
        ItemMeta itemMeta = Main.plugin.getServer().getItemFactory().getItemMeta(item.getType());
        ArrayList<String> lore = new ArrayList<String>();
        if (itemConfig.shouldAllowBuy()) {
            int buySize = itemConfig.getBuySize();
            double buyPrice = itemConfig.getBuyPrice();
            lore.add(Shop.replaceAmountCurrencyPricePlaceholders(pluginConfig.getItemBuyLore(), buySize, buyPrice));
            if (buySize < 64 && pluginConfig.shouldEnableStackBuying()) {
                stackPrice = buyPrice / (double)buySize * 64.0;
                lore.add(Shop.replaceAmountCurrencyPricePlaceholders(pluginConfig.getStackBuyLore(), 64, stackPrice));
            }
        } else {
            lore.add(net.md_5.bungee.api.ChatColor.RED + "Item Cannot be bought");
        }
        if (itemConfig.shouldAllowSell()) {
            int sellSize = itemConfig.getSellSize();
            double sellPrice = itemConfig.getSellPrice();
            lore.add(Shop.replaceAmountCurrencyPricePlaceholders(pluginConfig.getItemSellLore(), sellSize, sellPrice));
            if (sellSize < 64 && pluginConfig.shouldEnableStackBuying()) {
                stackPrice = sellPrice / (double)sellSize * 64.0;
                lore.add(Shop.replaceAmountCurrencyPricePlaceholders(pluginConfig.getStackSellLore(), 64, stackPrice));
            }
        } else {
            lore.add(net.md_5.bungee.api.ChatColor.RED + "Item Cannot be sold");
        }
        if (itemMeta != null) {
            itemMeta.setLore(lore);
            item.setItemMeta(itemMeta);
        }
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setString(NBT_SHOP_KEY, shopName);
        nbtItem.setInteger(NBT_ITEM_INDEX_KEY, Integer.valueOf(itemIndex));
        nbtItem.setBoolean(NBT_BUY_KEY, Boolean.valueOf(itemConfig.shouldAllowBuy()));
        nbtItem.setBoolean(NBT_SELL_KEY, Boolean.valueOf(itemConfig.shouldAllowSell()));
        return nbtItem.getItem();
    }

    private ItemStack createLogoFromInventory(Inventory inventory, ShopConfig shopConfig) {
        ItemStack logo = inventory.getItem(0);
        if (logo == null) {
            return null;
        }
        logo = logo.clone();
        ItemMeta itemMeta = logo.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)shopConfig.getFancyName()));
        itemMeta.setLore(new ArrayList());
        logo.setItemMeta(itemMeta);
        NBTItem nbtItem = new NBTItem(logo);
        nbtItem.setString(NBT_SHOP_KEY, shopConfig.getName());
        nbtItem.setBoolean(NBT_IS_SHOP_KEY, Boolean.valueOf(true));
        return nbtItem.getItem();
    }

    ShopConfig getConfig() {
        return this.config;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack getLogo() {
        return this.logo;
    }

    void onClick(InventoryClickEvent event, NBTItem nbtItem) {
        PluginConfig pluginConfig = Main.getPluginConfig();
        Player player = (Player)event.getWhoClicked();
        boolean isStackTransaction = event.isShiftClick() && pluginConfig.shouldEnableStackBuying();
        int itemIndex = nbtItem.getInteger(NBT_ITEM_INDEX_KEY);
        ItemConfig itemConfig = this.config.getItems().get(itemIndex);
        if (event.isLeftClick()) {
            this.buyItem(nbtItem, isStackTransaction, itemConfig, player);
        } else {
            this.sellItem(nbtItem, isStackTransaction, itemConfig, player);
        }
    }

    private void buyItem(NBTItem nbtItem, boolean isStackTransaction, ItemConfig itemConfig, Player player) {
        Economy economy = Main.getEconomy();
        boolean allowBuy = nbtItem.getBoolean(NBT_BUY_KEY);
        if (!allowBuy) {
            return;
        }
        int amountBought = isStackTransaction ? 64 : itemConfig.getBuySize();
        double price = isStackTransaction ? itemConfig.getBuyPrice() / (double)itemConfig.getBuySize() * 64.0 : itemConfig.getBuyPrice();
        if (economy.getBalance((OfflinePlayer)player) < price) {
            if (isStackTransaction) {
                player.sendMessage(net.md_5.bungee.api.ChatColor.RED + "You do not have enough money to buy a stack of this!");
            } else {
                player.sendMessage(net.md_5.bungee.api.ChatColor.RED + "You do not have enough money to buy this!");
            }
            return;
        }
        ItemStack shopItem = new ItemStack(itemConfig.getMaterial(), amountBought);
        player.getInventory().addItem(new ItemStack[]{shopItem});
        economy.withdrawPlayer((OfflinePlayer)player, price);
        String onItemBoughtCmd = this.getConfig().getOnItemBoughtCommand();
        if (onItemBoughtCmd != null) {
            player.performCommand(onItemBoughtCmd);
        }
    }

    private void sellItem(NBTItem nbtItem, boolean isStackTransaction, ItemConfig itemConfig, Player player) {
        int amountToSell;
        Economy economy = Main.getEconomy();
        boolean allowSell = nbtItem.getBoolean(NBT_SELL_KEY);
        if (!allowSell) {
            return;
        }
        int n = amountToSell = isStackTransaction ? 64 : itemConfig.getSellSize();
        if (!player.getInventory().contains(itemConfig.getMaterial(), amountToSell)) {
            player.sendMessage(net.md_5.bungee.api.ChatColor.RED + "You do not have enough of this item!");
            return;
        }
        double playerEarnings = itemConfig.getSellPrice() / (double)itemConfig.getSellSize() * (double)amountToSell;
        Shop.removeMatchingItemsFromPlayersInventory(player, itemConfig.getMaterial(), amountToSell);
        economy.depositPlayer((OfflinePlayer)player, playerEarnings);
        player.sendMessage(Shop.replaceAmountCurrencyPricePlaceholders(Main.getPluginConfig().getItemsSoldMessage(), amountToSell, playerEarnings));
        String onItemSoldCmd = this.getConfig().getOnItemSoldCommand();
        if (onItemSoldCmd != null) {
            player.performCommand(onItemSoldCmd);
        }
    }

    private static void removeMatchingItemsFromPlayersInventory(Player player, Material material, int amountToRemove) {
        PlayerInventory inventory = player.getInventory();
        for (int slot = 0; slot < inventory.getSize() && amountToRemove > 0; ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack == null || !itemStack.getType().equals((Object)material)) continue;
            if (amountToRemove >= itemStack.getAmount()) {
                inventory.clear(slot);
            } else {
                itemStack.setAmount(itemStack.getAmount() - amountToRemove);
                inventory.setItem(slot, itemStack);
            }
            amountToRemove -= itemStack.getAmount();
        }
    }
}

